/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.evict;

import io.higson.runtime.engine.core.prepared.PreparedParameter;
import io.higson.runtime.evict.IdleChecker;
import io.higson.runtime.utils.Clock;
import io.higson.runtime.utils.SystemClock;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIdleChecker
implements IdleChecker {
    private static final Logger log = LoggerFactory.getLogger(DefaultIdleChecker.class);
    private final long maxIdleMillis;
    private final Clock clock;

    public DefaultIdleChecker(long maxIdleMillis, Clock clock) {
        this.maxIdleMillis = maxIdleMillis;
        this.clock = clock;
    }

    public DefaultIdleChecker(long maxIdleMillis) {
        this(maxIdleMillis, new SystemClock());
    }

    public DefaultIdleChecker(Duration duration) {
        this(duration.toMillis());
    }

    @Override
    public long clockTime() {
        return this.clock.getTime();
    }

    @Override
    public boolean idleTimeExceeded(PreparedParameter pp) {
        return pp.getLastAccess() + this.maxIdleMillis < this.clockTime();
    }

    public Duration getIdleTimeout() {
        return Duration.ofMillis(this.maxIdleMillis);
    }

    public String toString() {
        return "DefaultIdleChecker[timeout=" + this.getIdleTimeout() + ", clock=" + this.clock + "]";
    }
}

