/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.function.log;

import io.higson.runtime.function.log.LogListener;
import io.higson.runtime.function.log.RuntimeLogger;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;

public final class ListenableLogger
implements RuntimeLogger {
    private final RuntimeLogger logger;
    private final Collection<LogListener> listeners;

    public ListenableLogger(RuntimeLogger logger, Collection<LogListener> listeners) {
        this.logger = logger;
        this.listeners = listeners;
    }

    public Collection<LogListener> getListeners() {
        return CollectionUtils.isEmpty(this.listeners) ? Collections.emptyList() : this.listeners;
    }

    private void listen(Level level, String msg, Object ... args) {
        String message = MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage();
        this.listeners.forEach(listener -> listener.listen(level, message));
    }

    @Override
    public boolean isTrace() {
        return this.logger.isTrace();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logger.trace(format, arguments);
        this.listen(Level.TRACE, format, arguments);
    }

    @Override
    public boolean isDebug() {
        return this.logger.isDebug();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.logger.debug(format, arguments);
        this.listen(Level.DEBUG, format, arguments);
    }

    @Override
    public boolean isInfo() {
        return this.logger.isInfo();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.logger.info(format, arguments);
        this.listen(Level.INFO, format, arguments);
    }

    @Override
    public boolean isWarn() {
        return this.logger.isWarn();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.logger.warn(format, arguments);
        this.listen(Level.WARN, format, arguments);
    }

    @Override
    public boolean isError() {
        return this.logger.isError();
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.logger.error(format, arguments);
        this.listen(Level.ERROR, format, arguments);
    }
}

