/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.parser;

import io.higson.runtime.engine.types.date.SimpleDateFormatPool;
import io.higson.runtime.helper.parser.LimitCache;
import java.text.ParseException;
import java.util.Date;

public class CachingDateParser {
    private static final LimitCache<String, Date> cache = new LimitCache("date-parser");

    public static void setCacheSize(int maxSize) {
        cache.setMaxSize(maxSize);
    }

    public static Date parse(String text, String pattern) {
        return pattern.length() == 10 ? CachingDateParser.doParseWithCache(text, pattern) : CachingDateParser.doParse(text, pattern);
    }

    static LimitCache<String, Date> cache() {
        return cache;
    }

    private static Date doParseWithCache(String text, String pattern) {
        Date date = cache.get(text);
        if (date == null) {
            date = CachingDateParser.doParse(text, pattern);
            cache.put(text, date);
        }
        return date;
    }

    private static Date doParse(String dateStr, String pattern) {
        try {
            return SimpleDateFormatPool.get(pattern).parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse date string [" + dateStr + "]", e);
        }
    }
}

