/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.model;

import io.higson.runtime.model.AttributeDefinition;
import io.higson.runtime.model.AttributeDefinitionImpl;
import io.higson.runtime.model.DomainObjectType;
import io.higson.runtime.model.DomainTokenResolver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DomainObjectTypeImpl
implements DomainObjectType {
    private final Integer id;
    private final String code;
    private final String name;
    private List<DomainObjectType> parentTypes = new ArrayList<DomainObjectType>();
    private List<DomainObjectType> childrenTypes = new ArrayList<DomainObjectType>();
    private List<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
    private Map<String, AttributeDefinition> attributeDefinitionMap = new HashMap<String, AttributeDefinition>();
    private Integer collectionType;
    private Integer typeId;
    private String typeCode;
    private String typeName;
    private boolean multiple;
    private boolean visible;
    private boolean rootCollection;
    private String parentTypeCode;
    private String typeNature;
    private int order;
    private Comparator<DomainObjectType> comparator = new CollectionComparator();
    private Comparator<AttributeDefinition> attrComparator = new AttrComparator();

    public DomainObjectTypeImpl(int id, String code, String name) {
        this.id = id;
        this.code = code;
        this.name = name;
    }

    @Override
    public List<DomainObjectType> getParentTypes() {
        ArrayList<DomainObjectType> copy = new ArrayList<DomainObjectType>(this.parentTypes);
        copy.sort(this.comparator);
        return copy;
    }

    public void addParentTypes(DomainObjectTypeImpl parentType) {
        this.parentTypes.add(parentType);
    }

    @Override
    public List<DomainObjectType> getChildrenTypes() {
        ArrayList<DomainObjectType> copy = new ArrayList<DomainObjectType>(this.childrenTypes);
        copy.sort(this.comparator);
        return copy;
    }

    public void addChildrenTypes(DomainObjectTypeImpl childrenType) {
        this.childrenTypes.add(childrenType);
    }

    @Override
    public List<AttributeDefinition> getAttributeDefinitions() {
        ArrayList<AttributeDefinition> copy = new ArrayList<AttributeDefinition>(this.attributeDefinitions);
        copy.sort(this.attrComparator);
        return copy;
    }

    @Override
    public AttributeDefinition getAttributeDefinition(String code) {
        return this.attributeDefinitionMap.get(code);
    }

    public void addAttributeDefinition(AttributeDefinition attrDefinition) {
        this.attributeDefinitions.add(attrDefinition);
        this.attributeDefinitionMap.put(attrDefinition.getCode(), attrDefinition);
    }

    public String getFullCode() {
        return DomainTokenResolver.resolveFullToken(this.parentTypeCode, this.code);
    }

    public String toString() {
        return "MppDomainObjectTypeDto [id=" + this.id + ", code=" + this.code + ", name=" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainObjectTypeImpl other = (DomainObjectTypeImpl)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Integer getId() {
        return this.id;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getCollectionType() {
        return this.collectionType;
    }

    public Integer getTypeId() {
        return this.typeId;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isRootCollection() {
        return this.rootCollection;
    }

    public String getParentTypeCode() {
        return this.parentTypeCode;
    }

    public String getTypeNature() {
        return this.typeNature;
    }

    public int getOrder() {
        return this.order;
    }

    public void setCollectionType(Integer collectionType) {
        this.collectionType = collectionType;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setRootCollection(boolean rootCollection) {
        this.rootCollection = rootCollection;
    }

    public void setParentTypeCode(String parentTypeCode) {
        this.parentTypeCode = parentTypeCode;
    }

    public void setTypeNature(String typeNature) {
        this.typeNature = typeNature;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private final class CollectionComparator
    implements Comparator<DomainObjectType> {
        private CollectionComparator() {
        }

        @Override
        public int compare(DomainObjectType o1, DomainObjectType o2) {
            return Integer.compare(((DomainObjectTypeImpl)o1).getOrder(), ((DomainObjectTypeImpl)o2).getOrder());
        }
    }

    final class AttrComparator
    implements Comparator<AttributeDefinition> {
        AttrComparator() {
        }

        @Override
        public int compare(AttributeDefinition o1, AttributeDefinition o2) {
            int groupCompare = StringUtils.trimToEmpty((String)o2.getGroupName()).compareTo(StringUtils.trimToEmpty((String)o1.getGroupName()));
            if (groupCompare == 0) {
                return Integer.compare(((AttributeDefinitionImpl)o1).getOrder(), ((AttributeDefinitionImpl)o2).getOrder());
            }
            return groupCompare;
        }
    }
}

