/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.model;

import io.higson.runtime.alias.LevelMapper;
import io.higson.runtime.engine.core.parameter.Level;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.helper.SqlUtil;
import io.higson.runtime.model.Element;
import io.higson.runtime.model.ParameterLevel;
import io.higson.runtime.sorter.SortConfig;
import io.higson.runtime.sorter.SortConfigParser;
import io.higson.runtime.utils.HprDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Parameter
implements io.higson.runtime.engine.core.parameter.Parameter,
Element {
    public static final char DEFAULT_ARRAY_SEPARATOR = ',';
    private int id;
    private String name;
    private final List<Level> levels = new ArrayList<Level>();
    private final Map<String, Integer> inputLevelIndexMap = new HashMap<String, Integer>();
    private final Collection<ParameterEntry> entries = new ArrayList<ParameterEntry>();
    private int inputLevels;
    private boolean nullable;
    private boolean dictionary;
    private boolean cacheable = true;
    private char arraySeparator = (char)44;
    private String sortText;
    private SortConfig sort;
    private Date lastUpdate;
    private int regionVersionId;
    private int entriesCount;
    private int mid;
    private LevelMapper levelMapper;
    private boolean slave;
    private String masterName;
    private boolean distinct;
    private boolean externalSource;
    private String externalInMemQuery;
    private String externalNonMemQuery;
    private String externalDataSource;
    private boolean autoRefresh;
    private String autoRefreshPeriod;
    private Date loadedAt;
    private String digest;
    private Parameter metadata;

    public void postprocess() {
        int i;
        TreeMap<String, Integer> code2outIx = new TreeMap<String, Integer>();
        for (i = 0; i < this.levels.size(); ++i) {
            String code = this.levels.get(i).getName();
            code2outIx.put(code, i - this.inputLevels);
        }
        if (this.sortText != null) {
            this.sort = new SortConfigParser(this.sortText, code2outIx).parseSafe();
        }
        for (i = 0; i < this.getInputLevels(); ++i) {
            ParameterLevel parameterLevel = this.getLevel(i);
            this.inputLevelIndexMap.put(parameterLevel.getName(), i);
        }
    }

    public boolean hasExternalStorage() {
        for (int i = 0; i < this.getLevelCount(); ++i) {
            if (!this.getLevel(i).isExternal()) continue;
            return true;
        }
        return false;
    }

    public int getLevelCount() {
        return this.levels.size();
    }

    public int getOutputLevels() {
        return this.getLevelCount() - this.getInputLevels();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Parameter#").append(this.id);
        sb.append('[').append(this.name);
        sb.append(", last=").append(HprDate.formatTimestamp(this.lastUpdate));
        sb.append(", levels=").append(this.getInputLevels()).append('/').append(this.getOutputLevels());
        sb.append(this.nullable ? ", nullable" : ", notnull");
        if (this.dictionary) {
            sb.append(", dictionary");
        }
        if (!this.cacheable) {
            sb.append(", nocache");
        }
        if (this.distinct) {
            sb.append(", distinct");
        }
        if (this.sort != null) {
            sb.append(", ").append(this.sort);
        }
        if (this.externalSource) {
            sb.append(", ext:");
            sb.append(" [inmem] = ").append(SqlUtil.printInline(this.externalInMemQuery));
            sb.append(" [nonmem] = ").append(SqlUtil.printInline(this.externalNonMemQuery));
        }
        if (this.autoRefresh) {
            sb.append(", refresh=").append(this.autoRefreshPeriod);
        }
        sb.append(", loaded=").append(HprDate.formatTimestamp(this.loadedAt));
        sb.append(", entries=").append(this.getEntriesCount());
        if (this.slave) {
            sb.append(", slave mid=").append(this.mid);
        }
        sb.append(']');
        return sb.toString();
    }

    public void setEntries(Set<ParameterEntry> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
    }

    public void addEntry(ParameterEntry entry) {
        this.entries.add(entry);
    }

    public void addLevel(ParameterLevel parameterLevel) {
        this.levels.add(parameterLevel);
    }

    public ParameterLevel getLevel(int ix) {
        if (ix < 0 || ix >= this.getLevelCount()) {
            throw new HigsonRuntimeException("Illegal level index: " + ix);
        }
        return (ParameterLevel)this.levels.get(ix);
    }

    public ParameterLevel getOutputLevel(int outIx) {
        return this.getLevel(this.inputLevels + outIx);
    }

    public int getInputLevelIndex(String code) {
        Integer ix = this.inputLevelIndexMap.get(code);
        if (ix == null) {
            throw new HigsonRuntimeException("Unknown input level [" + code + "] in " + this);
        }
        return ix;
    }

    public ParameterLevel getInputLevel(String code) {
        return this.getLevel(this.getInputLevelIndex(code));
    }

    public long getLoadedAtMillis() {
        return this.loadedAt != null ? this.loadedAt.getTime() : 0L;
    }

    public void setLoadedNow() {
        this.setLoadedAt(new Date());
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Level> getLevels() {
        return this.levels;
    }

    @Override
    public Collection<ParameterEntry> getEntries() {
        return this.entries;
    }

    @Override
    public int getInputLevels() {
        return this.inputLevels;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isDictionary() {
        return this.dictionary;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public char getArraySeparator() {
        return this.arraySeparator;
    }

    public SortConfig getSort() {
        return this.sort;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public int getRegionVersionId() {
        return this.regionVersionId;
    }

    public int getEntriesCount() {
        return this.entriesCount;
    }

    public int getMid() {
        return this.mid;
    }

    public LevelMapper getLevelMapper() {
        return this.levelMapper;
    }

    public boolean isSlave() {
        return this.slave;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isExternalSource() {
        return this.externalSource;
    }

    public String getExternalInMemQuery() {
        return this.externalInMemQuery;
    }

    public String getExternalNonMemQuery() {
        return this.externalNonMemQuery;
    }

    public String getExternalDataSource() {
        return this.externalDataSource;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public String getAutoRefreshPeriod() {
        return this.autoRefreshPeriod;
    }

    public Date getLoadedAt() {
        return this.loadedAt;
    }

    @Override
    public Parameter getMetadata() {
        return this.metadata;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInputLevels(int inputLevels) {
        this.inputLevels = inputLevels;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setDictionary(boolean dictionary) {
        this.dictionary = dictionary;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public void setArraySeparator(char arraySeparator) {
        this.arraySeparator = arraySeparator;
    }

    public void setSortText(String sortText) {
        this.sortText = sortText;
    }

    public void setSort(SortConfig sort) {
        this.sort = sort;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setRegionVersionId(int regionVersionId) {
        this.regionVersionId = regionVersionId;
    }

    public void setEntriesCount(int entriesCount) {
        this.entriesCount = entriesCount;
    }

    public void setMid(int mid) {
        this.mid = mid;
    }

    public void setLevelMapper(LevelMapper levelMapper) {
        this.levelMapper = levelMapper;
    }

    public void setSlave(boolean slave) {
        this.slave = slave;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setExternalSource(boolean externalSource) {
        this.externalSource = externalSource;
    }

    public void setExternalInMemQuery(String externalInMemQuery) {
        this.externalInMemQuery = externalInMemQuery;
    }

    public void setExternalNonMemQuery(String externalNonMemQuery) {
        this.externalNonMemQuery = externalNonMemQuery;
    }

    public void setExternalDataSource(String externalDataSource) {
        this.externalDataSource = externalDataSource;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public void setAutoRefreshPeriod(String autoRefreshPeriod) {
        this.autoRefreshPeriod = autoRefreshPeriod;
    }

    public void setLoadedAt(Date loadedAt) {
        this.loadedAt = loadedAt;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void setMetadata(Parameter metadata) {
        this.metadata = metadata;
    }
}

