/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler;

import io.higson.runtime.profiler.AbstractProfilerStat;
import io.higson.runtime.profiler.ProfilerBucket;
import io.higson.runtime.profiler.ProfilerHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractProfiler<T, S extends AbstractProfilerStat<T>> {
    private final List<ProfilerBucket<T, S>> buckets;
    private final int bucketCount;

    protected AbstractProfiler(int bucketCount) {
        this.bucketCount = bucketCount;
        this.buckets = new ArrayList<ProfilerBucket<T, S>>(bucketCount);
        for (int i = 0; i < bucketCount; ++i) {
            this.buckets.add(new ProfilerBucket());
        }
    }

    public void addTime(T key, long time) {
        if (key == null) {
            key = this.getNullKey();
        }
        this.getBucket().addTime(key, time, this.getKeyStatsSupplier());
    }

    public void addTime(T key, long t1, long t2) {
        this.addTime(key, t2 - t1);
    }

    private ProfilerBucket<T, S> getBucket() {
        long tid = Thread.currentThread().getId();
        int ix = (int)(tid % (long)this.bucketCount);
        return this.buckets.get(ix);
    }

    public void clear() {
        this.buckets.forEach(ProfilerBucket::clear);
    }

    public S getStat(T key) {
        AbstractProfilerStat result = (AbstractProfilerStat)this.getKeyStatsSupplier().apply(key);
        this.buckets.stream().map(bucket -> bucket.getStat(key, this.getStatsSupplier())).filter(Objects::nonNull).forEach(result::add);
        return (S)result;
    }

    public String printSummary() {
        return this.printSummary("Profiler summary");
    }

    public String printSummary(String title) {
        List<S> stats = this.getStatistics();
        return this.printSummary(stats, title);
    }

    public String printSummary(List<S> statistics, String title) {
        return ProfilerHelper.printSummary(statistics, title);
    }

    public List<S> getStatistics() {
        List<S> stats = this.getStats();
        return this.sort(stats);
    }

    private List<S> getStats() {
        HashMap resultMap = new HashMap();
        this.buckets.forEach(b -> this.addBucketToResult((ProfilerBucket<T, S>)b, resultMap));
        return new ArrayList(resultMap.values());
    }

    private void addBucketToResult(ProfilerBucket<T, S> bucket, Map<T, S> resultMap) {
        bucket.getStats(this.getStatsSupplier()).forEach(stat -> resultMap.computeIfAbsent(stat.getKey(), k -> (AbstractProfilerStat)this.getKeyStatsSupplier().apply(k)).add(stat));
    }

    public List<S> sort(List<S> stats) {
        stats.sort(this.getComparator());
        return stats;
    }

    public abstract Comparator<S> getComparator();

    public abstract T getNullKey();

    public abstract Function<S, S> getStatsSupplier();

    public abstract Function<T, S> getKeyStatsSupplier();
}

