/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.provider;

import io.higson.runtime.core.extdatasource.ExternalDataSourceProvider;
import io.higson.runtime.dao.external.ExternalStorageDao;
import io.higson.runtime.dao.parameter.ParameterDao;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.distinct.DistinctFilter;
import io.higson.runtime.engine.core.context.LevelValuesFlattener;
import io.higson.runtime.engine.core.parameter.ParamRepository;
import io.higson.runtime.engine.core.parameter.Parameter;
import io.higson.runtime.engine.core.parameter.ParameterBatchLoader;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.helper.MpHelper;
import io.higson.runtime.helper.uid.Uid;
import io.higson.runtime.helper.uid.UidParser;
import io.higson.runtime.profiler.engine.EngineProfiler;
import io.higson.runtime.provider.external.ExtSqlExecutor;
import io.higson.runtime.sync.PidCache;
import io.higson.runtime.sync.Trackable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpParameterProvider
implements ParamRepository {
    private static final Logger log = LoggerFactory.getLogger(MpParameterProvider.class);
    private static final EngineProfiler profiler = EngineProfiler.PARAMETER;
    private final ParameterDao dao;
    private final ExternalStorageDao externalDao;
    private final MpHelper helper = new MpHelper();
    private final DistinctFilter distinct = new DistinctFilter();
    private final PidCache pidCache = new PidCache();
    private final int maxConcurrentLoads;
    private final AtomicInteger concurrentLoadCounter = new AtomicInteger();
    private final Semaphore semaphore;
    private final ExtSqlExecutor extSqlExecutor;

    public MpParameterProvider(ParameterDao dao, ExternalStorageDao externalDao, int maxConcurrentLoads, ExternalDataSourceProvider externalDataSourceProvider, ConnectionInterceptor connectionInterceptor) {
        this.dao = dao;
        this.externalDao = externalDao;
        this.maxConcurrentLoads = maxConcurrentLoads;
        this.semaphore = new Semaphore(this.maxConcurrentLoads, true);
        this.extSqlExecutor = new ExtSqlExecutor(externalDataSourceProvider, connectionInterceptor);
    }

    public MpParameterProvider(ParameterDao dao, ExternalStorageDao externalDao, int maxConcurrentLoads) {
        this(dao, externalDao, maxConcurrentLoads, null, null);
    }

    public MpParameterProvider(ParameterDao dao, ExternalStorageDao externalDao) {
        this(dao, externalDao, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameter load(String uid) {
        long t = System.currentTimeMillis();
        try {
            Parameter parameter = this.loadWithQueue(uid);
            return parameter;
        }
        finally {
            profiler.addLoadMeasure(uid, t, System.currentTimeMillis());
        }
    }

    private Parameter _load(String uid) {
        log.debug("enter load, uid={}", (Object)uid);
        io.higson.runtime.model.Parameter p = this.doLoad(uid);
        if (p != null) {
            if (p.hasExternalStorage()) {
                this.externalDao.resolveExternalValues(p);
            }
            if (p.isDistinct()) {
                this.distinct.filter(p);
            }
            io.higson.runtime.model.Parameter metadata = this.helper.copyDefinition(p);
            this.pidCache.set(p.getId(), metadata);
            p.setMetadata(metadata);
        }
        return p;
    }

    private Parameter loadWithQueue(String uid) {
        try {
            this.semaphore.acquireUninterruptibly();
            this.concurrentLoadCounter.incrementAndGet();
            Parameter parameter = this._load(uid);
            return parameter;
        }
        finally {
            this.concurrentLoadCounter.decrementAndGet();
            this.semaphore.release();
        }
    }

    private io.higson.runtime.model.Parameter doLoad(String uid) {
        Uid spec = UidParser.parseUid(uid);
        return this.dao.getParameter(spec.getCode(), spec.getVersion(), spec.getSid(), spec.getMid());
    }

    public Date getLastUpdate() {
        return this.dao.getMaxLastUpdate();
    }

    public Date getLastUpdate(boolean developerMode) {
        return this.dao.getMaxLastUpdate(developerMode);
    }

    public List<Trackable> getAllLastUpdates(boolean developerMode) {
        return this.dao.getAllLastUpdates(developerMode);
    }

    @Override
    public Collection<ParameterEntry> findEntries(int pid, String[][] inputLevels) {
        io.higson.runtime.model.Parameter def = this.pidCache.get(pid);
        if (def.isExternalSource()) {
            String[] flattenInput = LevelValuesFlattener.flatten(inputLevels);
            return this.extSqlExecutor.findEntries(def, flattenInput);
        }
        int matrixPid = def.isSlave() ? def.getMid() : pid;
        Collection<ParameterEntry> result = this.dao.findEntries(matrixPid, inputLevels);
        if (def.hasExternalStorage()) {
            this.externalDao.resolveExternalValues(def, result);
        }
        return result;
    }

    @Override
    public ParameterBatchLoader batchLoad(String parameterName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> listParameters() {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfLoadsInProgress() {
        return this.concurrentLoadCounter.get();
    }

    public PidCache getPidCache() {
        return this.pidCache;
    }

    public int getMaxConcurrentLoads() {
        return this.maxConcurrentLoads;
    }
}

