/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sync;

import io.higson.runtime.dev.DevModeProvider;
import io.higson.runtime.sync.BaseWatcher;
import java.util.Date;

public class DevModeWatcher
extends BaseWatcher
implements Runnable {
    private final DevModeProvider provider;
    private Date timestamp;

    public DevModeWatcher(DevModeProvider provider) {
        this.provider = provider;
    }

    @Override
    public void doWatch() {
        this.log.debug("starting developer mode watcher action");
        Date maxLastUpdate = this.provider.getSessionMaxLastUpdate();
        if (this.log.isDebugEnabled()) {
            this.log.debug("fetched max last update:{}", (Object)this.print(maxLastUpdate));
        }
        if (this.possibleModification(maxLastUpdate)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("checking possible modification, newer last update: {}", (Object)this.print(maxLastUpdate));
            }
            this.provider.invalidateSessionCache();
            this.timestamp = maxLastUpdate;
            if (this.log.isDebugEnabled()) {
                this.log.debug("last update set to: {}", (Object)this.print(this.timestamp));
            }
        }
        this.log.debug("developer mode watcher action finished");
    }

    @Override
    protected String getWatcherName() {
        return "devmode-watcher";
    }

    private boolean possibleModification(Date lastUpdate) {
        return lastUpdate != null && (this.timestamp == null || lastUpdate.getTime() > this.timestamp.getTime());
    }
}

