/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.type;

import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.types.bool.BooleanHolder;
import io.higson.runtime.engine.util.EngineUtil;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class BooleanType
implements Type<BooleanHolder> {
    private static final String DEFAULT_TRUE_LITERALS = "true, t, yes, y, tak, 1";
    private static final String DEFAULT_FALSE_LITERALS = "false, f, no, n, nie, 0";
    protected static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private Set<String> trueSet;
    private Set<String> falseSet;

    public BooleanType() {
        this.setTrueLiterals(DEFAULT_TRUE_LITERALS);
        this.setFalseLiterals(DEFAULT_FALSE_LITERALS);
    }

    private Set<String> toSet(String commaSeparatedValues) {
        String[] tokens;
        HashSet<String> set = new HashSet<String>();
        for (String token : tokens = EngineUtil.split(commaSeparatedValues, ',')) {
            set.add(this.lowercase(token.trim()));
        }
        return set;
    }

    public final void setTrueLiterals(String trueLiterals) {
        this.trueSet = this.toSet(trueLiterals);
    }

    public final void setFalseLiterals(String falseLiterals) {
        this.falseSet = this.toSet(falseLiterals);
    }

    @Override
    public String encode(BooleanHolder holder) {
        return String.valueOf(holder.getBoolean());
    }

    @Override
    public BooleanHolder decode(String text) {
        Boolean value = EngineUtil.hasText(text) ? Boolean.valueOf(this.parse(text)) : null;
        return new BooleanHolder(value);
    }

    @Override
    public BooleanHolder convert(Object obj) {
        if (obj instanceof Boolean) {
            return new BooleanHolder((Boolean)obj);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        if (obj == null) {
            return new BooleanHolder(null);
        }
        if (obj instanceof Number) {
            double v = ((Number)obj).doubleValue();
            return new BooleanHolder(Math.abs(v) > 1.0E-6);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    public BooleanHolder[] newArray(int size) {
        return new BooleanHolder[size];
    }

    private boolean parse(String text) {
        String str = this.lowercase(text.trim());
        if (this.trueSet.contains(str)) {
            return true;
        }
        if (this.falseSet.contains(str)) {
            return false;
        }
        throw new HigsonRuntimeException(String.format("boolean text value cannot be correctly decoded: '%s'", str));
    }

    protected String lowercase(String str) {
        return str.toLowerCase(DEFAULT_LOCALE);
    }

    public boolean canDecode(String text) {
        return text != null && !text.isEmpty() && (this.trueSet.contains(text.toLowerCase()) || this.falseSet.contains(text.toLowerCase()));
    }
}

