/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.annotated.scanner;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.smartparam.engine.annotated.PackageList;
import org.smartparam.engine.annotated.RepositoryObjectKey;
import org.smartparam.engine.annotated.scanner.AnnotatedObjectFactory;
import org.smartparam.engine.util.reflection.ReflectionsConstructorUtil;
import org.smartparam.engine.util.reflection.ReflectionsScanner;

public class AnnotatedObjectsScanner<T> {
    private ReflectionsScanner reflectionsScanner = new ReflectionsScanner();
    private AnnotatedObjectFactory annotatedObjectFactory = new AnnotatedObjectFactory();

    public Map<RepositoryObjectKey, T> getAnnotatedObjects(Class<? extends Annotation> annotationClass, PackageList packagesToScan) {
        Set<Class<?>> annotatedObjectClasses = this.reflectionsScanner.findClassesAnnotatedWith(annotationClass, packagesToScan.getPackages());
        HashMap objects = new HashMap();
        for (Class<?> type : annotatedObjectClasses) {
            Annotation typeAnnotation = type.getAnnotation(annotationClass);
            for (Map.Entry<RepositoryObjectKey, ?> entry : this.annotatedObjectFactory.createObjects(type, typeAnnotation).entrySet()) {
                objects.put(entry.getKey(), entry.getValue());
            }
        }
        return objects;
    }

    public List<T> getAnnotatedObjectsWithoutName(Class<? extends Annotation> annotationClass, PackageList packagesToScan) {
        Set<Class<?>> annotatedObjectClasses = this.reflectionsScanner.findClassesAnnotatedWith(annotationClass, packagesToScan.getPackages());
        ArrayList objects = new ArrayList(annotatedObjectClasses.size());
        for (Class<?> type : annotatedObjectClasses) {
            objects.add(ReflectionsConstructorUtil.createObject(type));
        }
        return objects;
    }

    public void setReflectionsScanner(ReflectionsScanner reflectionsScanner) {
        this.reflectionsScanner = reflectionsScanner;
    }

    public void setAnnotatedObjectFactory(AnnotatedObjectFactory annotatedObjectFactory) {
        this.annotatedObjectFactory = annotatedObjectFactory;
    }
}

