/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.integer;

import org.smartparam.engine.annotated.annotations.ParamType;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.types.integer.IntegerHolder;
import org.smartparam.engine.util.EngineUtil;

@ParamType(value="integer")
public class IntegerType
implements Type<IntegerHolder> {
    @Override
    public String encode(IntegerHolder holder) {
        Long v = holder.getValue();
        return v != null ? v.toString() : null;
    }

    @Override
    public IntegerHolder decode(String text) {
        Long value = EngineUtil.hasText(text) ? Long.valueOf(text.trim()) : null;
        return new IntegerHolder(value);
    }

    @Override
    public IntegerHolder convert(Object obj) {
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            Number n = (Number)obj;
            return new IntegerHolder(n.longValue());
        }
        if (obj == null) {
            return new IntegerHolder(null);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    public IntegerHolder[] newArray(int size) {
        return new IntegerHolder[size];
    }
}

