/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.type;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.types.integer.IntegerHolder;

public class IntegerType
extends org.smartparam.engine.types.integer.IntegerType {
    private static final Logger log = LoggerFactory.getLogger(IntegerType.class);
    private static final int CACHE_SIZE = 10000;
    private static final int MAP_CAPACITY = 13334;
    private static final Map<String, IntegerHolder> CACHE = new HashMap<String, IntegerHolder>(13334);
    private static final IntegerHolder NULL = new IntegerHolder(null);

    @Override
    public IntegerHolder decode(String str) {
        if (str == null) {
            return NULL;
        }
        String text = str.trim();
        if (text.isEmpty()) {
            return NULL;
        }
        IntegerHolder h = CACHE.get(text);
        if (h != null) {
            return h;
        }
        return new IntegerHolder(Long.valueOf(text));
    }

    static {
        for (long i = 0L; i < 10000L; ++i) {
            CACHE.put(String.valueOf(i), new IntegerHolder(i));
        }
        log.info("cached integer holders: {}", (Object)CACHE.size());
    }
}

