/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameImpl;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.community.dialect.TeradataSqlAstTranslator;
import org.hibernate.community.dialect.identity.Teradata14IdentityColumnSupport;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.internal.StandardIndexExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class TeradataDialect
extends Dialect {
    private static final DatabaseVersion DEFAULT_VERSION = DatabaseVersion.make((Integer)12, (Integer)0);
    private static final int PARAM_LIST_SIZE_LIMIT = 1024;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        int i;
        String constraintName;
        switch (sqle.getErrorCode()) {
            case 27003: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Unique constraint (", (String)") violated.", (String)sqle.getMessage());
                break;
            }
            case 2700: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Referential constraint", (String)"violation:", (String)sqle.getMessage());
                break;
            }
            case 5317: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Check constraint (", (String)") violated.", (String)sqle.getMessage());
                break;
            }
            default: {
                return null;
            }
        }
        if (constraintName != null && (i = constraintName.indexOf(46)) != -1) {
            constraintName = constraintName.substring(i + 1);
        }
        return constraintName;
    });

    public TeradataDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(DEFAULT_VERSION));
        this.registerKeywords(info);
    }

    public TeradataDialect() {
        this(DEFAULT_VERSION);
    }

    public TeradataDialect(DatabaseVersion version) {
        super(version);
    }

    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("password");
        this.registerKeyword("type");
        this.registerKeyword("title");
        this.registerKeyword("year");
        this.registerKeyword("month");
        this.registerKeyword("summary");
        this.registerKeyword("alias");
        this.registerKeyword("value");
        this.registerKeyword("first");
        this.registerKeyword("role");
        this.registerKeyword("account");
        this.registerKeyword("class");
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: 
            case 16: {
                return "byteint";
            }
            case -5: {
                return this.getVersion().isBefore(13) ? "numeric(19,0)" : "bigint";
            }
            case -2: {
                return "byte($l)";
            }
            case -3: {
                return "varbyte($l)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public int getDefaultStatementBatchSize() {
        return this.getVersion().isBefore(14) ? 0 : 15;
    }

    public boolean useInputStreamToInsertBlob() {
        return this.getVersion().isSameOrAfter(14);
    }

    public int getMaxVarcharLength() {
        return 32000;
    }

    public int getMaxVarbinaryLength() {
        return 64000;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case -7: {
                return jdbcTypeRegistry.getDescriptor(16);
            }
            case 2: 
            case 3: {
                if (precision != 19 || scale != 0) break;
                return jdbcTypeRegistry.getDescriptor(-5);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new TeradataSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    public int getDefaultDecimalPrecision() {
        return this.getVersion().isBefore(14) ? 18 : 38;
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("cast((?3-?2) ");
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("second");
                break;
            }
            case WEEK: {
                pattern.append("day");
                break;
            }
            case QUARTER: {
                pattern.append("month");
                break;
            }
            default: {
                pattern.append("?1");
            }
        }
        pattern.append("(4) as bigint)");
        switch (unit) {
            case WEEK: {
                pattern.append("/7");
                break;
            }
            case QUARTER: {
                pattern.append("/3");
                break;
            }
            case NANOSECOND: {
                pattern.append("*1e9");
            }
        }
        return pattern.toString();
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                return "(?3+(?2)/1e9*interval '1' second)";
            }
            case NATIVE: {
                return "(?3+(?2)*interval '1' second)";
            }
            case QUARTER: {
                return "(?3+(?2)*interval '3' month)";
            }
            case WEEK: {
                return "(?3+(?2)*interval '7' day)";
            }
        }
        return "(?3+(?2)*interval '1' ?1)";
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.concat_pipeOperator();
        functionFactory.octetLength();
        functionFactory.moreHyperbolic();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.position();
        functionFactory.bitLength_pattern("octet_length(cast(?1 as char))*4");
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("mod", "(?1 mod ?2)").setInvariantType(stringType).setExactArgumentCount(2).register();
        if (this.getVersion().isSameOrAfter(14)) {
            functionFactory.lastDay();
            functionFactory.initcap();
            functionFactory.trim2();
            functionFactory.soundex();
            functionFactory.ascii();
            functionFactory.char_chr();
            functionFactory.trunc();
            functionFactory.moreHyperbolic();
            functionFactory.monthsBetween();
            functionFactory.addMonths();
            functionFactory.stddevPopSamp();
            functionFactory.varPopSamp();
        }
        functionFactory.windowFunctions();
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
    }

    public String getForUpdateString() {
        return "";
    }

    public String getAddColumnString() {
        return this.getVersion().isBefore(14) ? super.getAddColumnString() : "add";
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, basename -> "HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    public String getTemporaryTableCreateOptions() {
        return "on commit preserve rows";
    }

    public int getMaxAliasLength() {
        return 20;
    }

    public int getMaxIdentifierLength() {
        return 30;
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public boolean supportsOrderByInSubquery() {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(16, 10);
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        String v = "null";
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                v = "cast(null as decimal)";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                v = "cast(null as varchar(255))";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                v = "cast(null as timestamp)";
                break;
            }
        }
        return v;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public String getCreateMultisetTableString() {
        return "create multiset table ";
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    public boolean supportsBindAsCallableArgument() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 1024;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, 2006);
        return ++col;
    }

    public ResultSet getResultSet(CallableStatement cs) throws SQLException {
        boolean isResultSet = cs.execute();
        while (!isResultSet && cs.getUpdateCount() != -1) {
            isResultSet = cs.getMoreResults();
        }
        return cs.getResultSet();
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return this.getVersion().isBefore(14) ? super.getViolatedConstraintNameExtractor() : EXTRACTOR;
    }

    public boolean supportsLockTimeouts() {
        return false;
    }

    public boolean supportsNoWait() {
        return true;
    }

    public boolean supportsWait() {
        return false;
    }

    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        return this.getVersion().isSameOrAfter(14);
    }

    public String getWriteLockString(int timeout) {
        if (this.getVersion().isBefore(14)) {
            return super.getWriteLockString(timeout);
        }
        String sMsg = " Locking row for write ";
        if (timeout == 0) {
            return sMsg + " nowait ";
        }
        return sMsg;
    }

    public String getReadLockString(int timeout) {
        if (this.getVersion().isBefore(14)) {
            return super.getReadLockString(timeout);
        }
        String sMsg = " Locking row for read  ";
        if (timeout == 0) {
            return sMsg + " nowait ";
        }
        return sMsg;
    }

    public Exporter<Index> getIndexExporter() {
        return new TeradataIndexExporter(this);
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion().isBefore(14) ? super.getIdentityColumnSupport() : Teradata14IdentityColumnSupport.INSTANCE;
    }

    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return this.getVersion().isBefore(14) ? super.applyLocksToSql(sql, aliasedLockOptions, keyColumnNames) : new ForUpdateFragment((Dialect)this, aliasedLockOptions, keyColumnNames).toFragmentString() + " " + sql;
    }

    public LimitHandler getLimitHandler() {
        return TopLimitHandler.INSTANCE;
    }

    private static class TeradataIndexExporter
    extends StandardIndexExporter
    implements Exporter<Index> {
        private TeradataIndexExporter(Dialect dialect) {
            super(dialect);
        }

        public String[] getSqlCreateStrings(Index index, Metadata metadata, SqlStringGenerationContext context) {
            QualifiedTableName qualifiedTableName = index.getTable().getQualifiedTableName();
            String tableName = context.format(qualifiedTableName);
            String indexNameForCreation = this.getDialect().qualifyIndexName() ? context.format((QualifiedName)new QualifiedNameImpl(qualifiedTableName.getCatalogName(), qualifiedTableName.getSchemaName(), Identifier.toIdentifier((String)index.getName()))) : index.getName();
            StringBuilder columnList = new StringBuilder();
            boolean first = true;
            for (Column column : index.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    columnList.append(", ");
                }
                columnList.append(column.getName());
            }
            return new String[]{"create index " + indexNameForCreation + "(" + columnList + ") on " + tableName};
        }
    }
}

