/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import com.zaxxer.hikari.HikariDataSource;
import io.higson.runtime.sql.DialectRegistry;
import io.higson.runtime.sql.DialectTemplate;
import jakarta.persistence.EntityManagerFactory;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.security.core.userdetails.UserDetailsService;
import pl.decerto.hyperon.common.configuration.HyperonCommonConfiguration;
import pl.decerto.hyperon.common.configuration.LiquibaseConfiguration;
import pl.decerto.hyperon.common.security.HigsonUserDetailsService;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;
import pl.decerto.hyperon.common.security.mapper.SystemUserMapper;
import pl.decerto.hyperon.common.utils.database.HyperonPhysicalNamingStrategy;
import pl.decerto.hyperon.rest.configuration.DatabaseProperties;
import pl.decerto.hyperon.rest.configuration.SwaggerConfiguration;
import pl.decerto.hyperon.rest.security.CachingHigsonUserDetailsService;
import pl.decerto.hyperon.rest.security.SystemUserCacheAwareProvider;

@Configuration
@Import(value={SwaggerConfiguration.class, HyperonCommonConfiguration.class, LiquibaseConfiguration.class})
public class HyperonRuntimeRestConfiguration {
    @Bean
    public DialectRegistry dialectRegistry(DatabaseProperties databaseProperties) {
        DialectRegistry registry = new DialectRegistry();
        registry.setDialect((Object)databaseProperties.getDialect());
        return registry;
    }

    @Bean
    public DialectTemplate dialectTemplate(DialectRegistry dialectRegistry) {
        return dialectRegistry.create();
    }

    @Bean(value={"dataSource"})
    public DataSource dataSource(DialectTemplate dialectTemplate, DatabaseProperties databaseProperties) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setUsername(databaseProperties.getDbUsername());
        dataSource.setPassword(databaseProperties.getDbPassword());
        dataSource.setJdbcUrl(databaseProperties.getDbUrl());
        dataSource.setDriverClassName(dialectTemplate.getJdbcDriverClassName());
        return dataSource;
    }

    @Bean
    @ConditionalOnProperty(prefix="higson.security.user", name={"cache"}, havingValue="true")
    UserDetailsService cachingHyperonUserDetailsService(UsersCacheManager usersCacheManager, SystemUserCacheAwareProvider systemUserCacheAwareProvider) {
        return new CachingHigsonUserDetailsService(usersCacheManager, systemUserCacheAwareProvider);
    }

    @Bean
    @ConditionalOnProperty(prefix="higson.security.user", name={"cache"}, havingValue="false", matchIfMissing=true)
    UserDetailsService userDetailsService(UserManagementDao userManagementDao, UsersCacheManager usersCacheManager, SystemUserMapper systemUserMapper) {
        return new HigsonUserDetailsService(userManagementDao, usersCacheManager, systemUserMapper);
    }

    @Bean
    LocalContainerEntityManagerFactoryBean entityManagerFactory(@Qualifier(value="dataSource") DataSource dataSource, DialectTemplate dialectTemplate, @Value(value="${higson.database.schema:#{null}}") String dbSchema, @Value(value="${higson.database.hbm2ddl-mode}") String hbm2ddlMode) {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setDataSource(dataSource);
        entityManagerFactoryBean.setPackagesToScan(new String[]{"pl.decerto.hyperon.common"});
        entityManagerFactoryBean.setPersistenceXmlLocation("classpath*:META-INF/mpp-persistence.xml");
        entityManagerFactoryBean.setPersistenceUnitName("mpp-pu");
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        entityManagerFactoryBean.setJpaPropertyMap(Map.of("hibernate.hbm2ddl.auto", hbm2ddlMode, "hibernate.dialect", dialectTemplate.getHibernateDialect(), "hibernate.physical_naming_strategy", HyperonPhysicalNamingStrategy.class.getName(), "hibernate.jdbc.batch_size", 200, "hibernate.jdbc.fetch_size", 500, "hibernate.cache.use_second_level_cache", false, "hibernate.cache.use_query_cache", false, "hibernate.default_schema", dbSchema, "hibernate.connection.charSet", "UTF-8"));
        return entityManagerFactoryBean;
    }

    @Bean
    JpaTransactionManager transactionManager(EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory);
        return transactionManager;
    }
}

