/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.List;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SwaggerConfiguration {
    private static final String JWT_AUTH_NAME = "jwt";
    private static final String BASIC_AUTH_NAME = "basic";
    private final BuildProperties buildProperties;
    @Value(value="${higson.runtime-rest.security.type:}")
    private String securityType;
    @Value(value="${higson.runtime-rest.openapi.servers:}")
    private List<String> serverUrls = new ArrayList<String>();

    @Bean
    public GroupedOpenApi api() {
        return GroupedOpenApi.builder().group("runtime-rest-api").pathsToExclude(new String[]{"/actuator/**", "/error.*"}).pathsToMatch(new String[]{"/**"}).build();
    }

    @Bean
    public OpenAPI higsonRuntimeRestOpenApi() {
        OpenAPI api = new OpenAPI().info(this.createInfo());
        this.addServers(api);
        this.addSecurity(api);
        return api;
    }

    private Info createInfo() {
        Contact contact = new Contact().email("higson@decerto.com").name("Higson Team").url("https://www.higson.io");
        return new Info().contact(contact).title("Higson Runtime REST API").description("Higson Runtime REST API endpoints").version(this.buildProperties.getVersion());
    }

    private void addServers(OpenAPI api) {
        if (!this.serverUrls.isEmpty()) {
            List<Server> servers = this.serverUrls.stream().map(url -> {
                Server server = new Server();
                server.setUrl(url);
                return server;
            }).toList();
            api.setServers(servers);
        }
    }

    private void addSecurity(OpenAPI api) {
        if (BASIC_AUTH_NAME.equals(this.securityType)) {
            SecurityScheme securityScheme = new SecurityScheme().scheme(BASIC_AUTH_NAME).type(SecurityScheme.Type.HTTP);
            api.schemaRequirement(BASIC_AUTH_NAME, securityScheme);
            api.addSecurityItem(new SecurityRequirement().addList(BASIC_AUTH_NAME));
        } else {
            SecurityScheme securityScheme = new SecurityScheme().scheme("bearer").type(SecurityScheme.Type.HTTP).bearerFormat("JWT");
            api.schemaRequirement(JWT_AUTH_NAME, securityScheme);
            api.addSecurityItem(new SecurityRequirement().addList(JWT_AUTH_NAME));
        }
    }

    public SwaggerConfiguration(BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }
}

