/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration.security;

import org.apache.commons.lang3.ArrayUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsPasswordService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
@Conditional(value={NoSecurityCondition.class})
@ConditionalOnProperty(name={"higson.runtime-rest.security.type"}, havingValue="basic")
public class BasicSecurityConfiguration {
    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http, AuthenticationProvider daoAuthenticationProvider) throws Exception {
        return (SecurityFilterChain)http.csrf(AbstractHttpConfigurer::disable).cors(AbstractHttpConfigurer::disable).sessionManagement(configurer -> configurer.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authenticationProvider(daoAuthenticationProvider).authorizeHttpRequests(requestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requestMatcherRegistry.requestMatchers(new String[]{"/api/v3/api-docs/**", "/swagger-ui/**", "/actuator/**"})).permitAll().anyRequest()).authenticated()).httpBasic(Customizer.withDefaults()).logout(configurer -> configurer.invalidateHttpSession(true)).build();
    }

    @Bean
    AuthenticationProvider daoAuthenticationProvider(PasswordEncoder higsonPasswordEncoder, UserDetailsService higsonUserDetailsService, UserDetailsPasswordService userDetailsPasswordService) {
        DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
        daoAuthenticationProvider.setPasswordEncoder(higsonPasswordEncoder);
        daoAuthenticationProvider.setUserDetailsService(higsonUserDetailsService);
        daoAuthenticationProvider.setUserDetailsPasswordService(userDetailsPasswordService);
        return daoAuthenticationProvider;
    }

    static class NoSecurityCondition
    implements ConfigurationCondition {
        NoSecurityCondition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Object[] activeProfiles = context.getEnvironment().getActiveProfiles();
            return !ArrayUtils.contains((Object[])activeProfiles, (Object)"no-security");
        }
    }
}

