/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution;

import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.util.MultiValueUtil;
import io.higson.runtime.model.DomainAttribute;
import io.higson.runtime.model.DomainObject;
import io.higson.runtime.model.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pl.decerto.hyperon.rest.configuration.HyperonThreadPoolProperties;
import pl.decerto.hyperon.rest.execution.ArgumentsBuilder;
import pl.decerto.hyperon.rest.execution.ContextBuilder;
import pl.decerto.hyperon.rest.execution.EffectiveVersionManager;
import pl.decerto.hyperon.rest.execution.ExecutionService;
import pl.decerto.hyperon.rest.execution.MissingAttributeException;
import pl.decerto.hyperon.rest.execution.api.dto.BatchExecutionContext;
import pl.decerto.hyperon.rest.execution.api.dto.BatchExecutionData;
import pl.decerto.hyperon.rest.execution.api.dto.BatchExecutionResult;
import pl.decerto.hyperon.rest.execution.api.dto.EffectiveVersionConfigurationDto;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionData;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionElementIdentifier;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionResult;
import pl.decerto.hyperon.rest.execution.api.dto.InvocationResultField;
import pl.decerto.hyperon.rest.execution.api.dto.InvocationResultRow;
import pl.decerto.hyperon.rest.execution.api.dto.MppResultField;
import pl.decerto.hyperon.rest.execution.api.dto.MppResultRow;

@Service
public class ExecutionServiceImpl
implements ExecutionService {
    private static final Logger log = LoggerFactory.getLogger(ExecutionServiceImpl.class);
    private final HigsonEngine higsonEngine;
    private final EffectiveVersionManager effectiveVersionManager;
    private final ContextBuilder contextBuilder;
    private final ArgumentsBuilder argumentsBuilder;
    private final HyperonThreadPoolProperties threadPoolProperties;

    @Override
    public List<ExecutionResult> execute(ExecutionData executionData) {
        this.effectiveVersionManager.set(executionData.getEffectiveVersionConfiguration());
        ArrayList<ExecutionResult> result = new ArrayList<ExecutionResult>();
        HigsonContext ctx = this.contextBuilder.create(executionData);
        Object[] arguments = this.argumentsBuilder.create(executionData.getArguments());
        for (ExecutionElementIdentifier element : executionData.getElements()) {
            this.validateElementData(element);
            Object elementExecResult = this.doExecuteOne(element, ctx, arguments);
            result.add(new ExecutionResult(element, elementExecResult));
        }
        this.effectiveVersionManager.clear();
        return result;
    }

    Object doExecuteOne(ExecutionElementIdentifier element, HigsonContext ctx, Object ... args) {
        log.debug("Executing element: {}", (Object)element);
        return switch (element.getType()) {
            case ElementType.FUNCTION -> this.callFunction(element.getCode(), ctx, args);
            case ElementType.PARAMETER -> this.getParameter(element.getCode(), ctx);
            case ElementType.DOMAIN_OBJECT -> this.callDomain(element.getProfileCode(), element.getCode(), element.getAttributeCode(), ctx);
            default -> null;
        };
    }

    @Override
    public List<ExecutionResult> invoke(ExecutionData executionData) {
        this.effectiveVersionManager.set(executionData.getEffectiveVersionConfiguration());
        HigsonContext ctx = this.contextBuilder.create(executionData);
        Object[] arguments = this.argumentsBuilder.create(executionData.getArguments());
        List<ExecutionResult> result = executionData.getElements().stream().map(element -> {
            this.validateElementData((ExecutionElementIdentifier)element);
            Object elementExecResult = this.doInvokeOne((ExecutionElementIdentifier)element, ctx, arguments);
            return new ExecutionResult((ExecutionElementIdentifier)element, elementExecResult);
        }).collect(Collectors.toList());
        this.effectiveVersionManager.clear();
        return result;
    }

    @Override
    public BatchExecutionResult batchInvoke(BatchExecutionData batchExecutionData) {
        Object[] arguments = this.argumentsBuilder.create(batchExecutionData.getArguments());
        List<ExecutionElementIdentifier> elements = batchExecutionData.getElements();
        List<BatchExecutionContext> ctxList = batchExecutionData.getCtxList();
        BatchExecutionResult batchExecutionResult = new BatchExecutionResult();
        EffectiveVersionConfigurationDto effectiveVersionConfiguration = batchExecutionData.getEffectiveVersionConfiguration();
        ExecutorService executor = Executors.newFixedThreadPool(this.threadPoolProperties.getCount());
        log.info("batch-invoke executor: {}", (Object)executor);
        ctxList.stream().map(ctx -> () -> this.doInvokeBatch((BatchExecutionContext)ctx, arguments, elements, batchExecutionResult, effectiveVersionConfiguration)).map(task -> CompletableFuture.runAsync(task, executor)).forEach(CompletableFuture::join);
        executor.shutdown();
        return batchExecutionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doInvokeBatch(BatchExecutionContext executionContext, Object[] arguments, List<ExecutionElementIdentifier> elements, BatchExecutionResult batchExecutionResult, EffectiveVersionConfigurationDto effectiveVersionConfiguration) {
        try {
            this.effectiveVersionManager.set(effectiveVersionConfiguration);
            HigsonContext context = this.contextBuilder.create(executionContext.getProperties());
            elements.forEach(element -> {
                this.validateElementData((ExecutionElementIdentifier)element);
                Object resultValue = this.doInvokeOne((ExecutionElementIdentifier)element, context, arguments);
                BatchExecutionResult.Result result = new BatchExecutionResult.Result(executionContext.getId(), (ExecutionElementIdentifier)element, resultValue);
                batchExecutionResult.addResult(result);
            });
        }
        finally {
            this.effectiveVersionManager.clear();
        }
    }

    Object doInvokeOne(ExecutionElementIdentifier element, HigsonContext ctx, Object ... args) {
        log.debug("Invoking element: {}", (Object)element);
        return switch (element.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ElementType.FUNCTION -> this.invokeFunction(element.getCode(), ctx, ExecutionServiceImpl.getFunctionArgs(element, args));
            case ElementType.PARAMETER -> this.invokeParameter(element.getCode(), ctx);
            case ElementType.DOMAIN_OBJECT -> this.invokeDomain(element.getProfileCode(), element.getCode(), element.getAttributeCode(), ctx);
            case ElementType.FLOW -> this.invokeFlow(element.getCode(), ctx, ExecutionServiceImpl.getFunctionArgs(element, args));
        };
    }

    private static Object[] getFunctionArgs(ExecutionElementIdentifier element, Object[] globalArgs) {
        return CollectionUtils.isNotEmpty(element.getFunctionArguments()) ? element.getFunctionArguments().toArray() : globalArgs;
    }

    private List<InvocationResultRow> invokeDomain(String profileCode, String domainPath, String attributeCode, HigsonContext ctx) {
        DomainObject domainObject = this.higsonEngine.getDomain(profileCode, domainPath);
        DomainAttribute attr = domainObject.getAttr(attributeCode);
        if (Objects.isNull(attr)) {
            return this.invokeDynamicAttribute(attributeCode, ctx, domainObject);
        }
        ParamValue value = attr.getValue((ParamContext)ctx, new Object[0]);
        return this.convertResultRows(value);
    }

    private List<MppResultRow> callDomain(String profileCode, String domainPath, String attributeCode, HigsonContext ctx) {
        DomainObject domainObject = this.higsonEngine.getDomain(profileCode, domainPath);
        DomainAttribute attr = domainObject.getAttr(attributeCode);
        if (Objects.isNull(attr)) {
            return this.callDynamicAttribute(attributeCode, ctx, domainObject);
        }
        ParamValue value = attr.getValue((ParamContext)ctx, new Object[0]);
        return this.getResultRows(value);
    }

    private List<InvocationResultRow> invokeDynamicAttribute(String attributeCode, HigsonContext ctx, DomainObject domainObject) {
        DomainAttribute dynamicAttribute = domainObject.getDynamicAttribute(attributeCode);
        if (Objects.isNull(dynamicAttribute)) {
            throw new MissingAttributeException("missing domain attribute:" + attributeCode);
        }
        ParamValue value = dynamicAttribute.getValue((ParamContext)ctx, new Object[0]);
        return this.convertResultRows(value);
    }

    private List<MppResultRow> callDynamicAttribute(String attributeCode, HigsonContext ctx, DomainObject domainObject) {
        DomainAttribute dynamicAttribute = domainObject.getDynamicAttribute(attributeCode);
        if (Objects.isNull(dynamicAttribute)) {
            throw new MissingAttributeException("missing domain attribute:" + attributeCode);
        }
        ParamValue value = dynamicAttribute.getValue((ParamContext)ctx, new Object[0]);
        return this.getResultRows(value);
    }

    private List<MppResultRow> getParameter(String parameterCode, HigsonContext ctx) {
        log.debug("Executing parameter:{}", (Object)parameterCode);
        ParamValue elementExecResult = this.higsonEngine.get(parameterCode, (ParamContext)ctx);
        if (elementExecResult != null) {
            log.debug("Parameter result class = {}", (Object)elementExecResult.getClass().getName());
            return this.getResultRows(elementExecResult);
        }
        log.debug("Parameter result is empty, returning empty list");
        return Collections.emptyList();
    }

    private List<InvocationResultRow> invokeParameter(String parameterCode, HigsonContext ctx) {
        log.debug("Executing parameter:{}", (Object)parameterCode);
        ParamValue elementExecResult = this.higsonEngine.get(parameterCode, (ParamContext)ctx);
        if (elementExecResult != null) {
            log.debug("Parameter result class = {}", (Object)elementExecResult.getClass().getName());
            return this.convertResultRows(elementExecResult);
        }
        log.debug("Parameter result is empty, returning empty list");
        return Collections.emptyList();
    }

    private Object invokeFunction(String functionCode, HigsonContext ctx, Object ... args) {
        log.debug("Invoking function:{}", (Object)functionCode);
        List<InvocationResultRow> elementExecResult = this.higsonEngine.call(functionCode, (ParamContext)ctx, args);
        if (elementExecResult instanceof ParamValue) {
            elementExecResult = this.convertResultRows((ParamValue)elementExecResult);
        }
        return elementExecResult;
    }

    private Object invokeFlow(String flowCode, HigsonContext ctx, Object ... args) {
        log.debug("Invoking flow:{}", (Object)flowCode);
        return this.higsonEngine.flow(flowCode, (ParamContext)ctx, args);
    }

    private List<InvocationResultRow> convertResultRows(ParamValue value) {
        log.debug("Extracting result rows from param value:{}", (Object)value);
        return value.stream().map(this::convertToResultRow).collect(Collectors.toList());
    }

    private InvocationResultRow convertToResultRow(MultiValue mv) {
        List<InvocationResultField> fields = this.convertFields(mv);
        InvocationResultRow row = new InvocationResultRow();
        row.setFields(fields);
        return row;
    }

    private List<InvocationResultField> convertFields(MultiValue mv) {
        List fieldKeys = MultiValueUtil.getKeys((MultiValue)mv);
        if (fieldKeys.isEmpty()) {
            return this.getInvocationResultsFromLiteralMultiValue(mv);
        }
        return this.createInvocationResultFields(mv, fieldKeys);
    }

    private List<InvocationResultField> getInvocationResultsFromLiteralMultiValue(MultiValue mv) {
        return Arrays.stream(mv.unwrap()).map(this::createInvocationResultField).collect(Collectors.toList());
    }

    private InvocationResultField createInvocationResultField(Object o) {
        InvocationResultField field = new InvocationResultField();
        field.setValue(Objects.isNull(o) ? null : o.toString());
        return field;
    }

    private List<InvocationResultField> createInvocationResultFields(MultiValue mv, List<String> fieldKeys) {
        return fieldKeys.stream().map(key -> this.convertToInvocationField(mv, (String)key)).collect(Collectors.toList());
    }

    private InvocationResultField convertToInvocationField(MultiValue mv, String key) {
        InvocationResultField field = new InvocationResultField();
        field.setField(key);
        if (mv.isArray(key)) {
            field.setValues(mv.getStringArray(key));
            return field;
        }
        ValueHolder holder = mv.getHolder(key);
        field.setValue(holder.getValue());
        return field;
    }

    private Object callFunction(String functionCode, HigsonContext ctx, Object ... args) {
        log.debug("Executing function:{}", (Object)functionCode);
        List<MppResultRow> elementExecResult = this.higsonEngine.call(functionCode, (ParamContext)ctx, args);
        if (elementExecResult instanceof ParamValue) {
            elementExecResult = this.getResultRows((ParamValue)elementExecResult);
        }
        return elementExecResult;
    }

    private List<MppResultRow> getResultRows(ParamValue value) {
        log.debug("Extracting result rows from param value:{}", (Object)value);
        return value.stream().map(this::convertToRow).collect(Collectors.toList());
    }

    private MppResultRow convertToRow(MultiValue mv) {
        List<MppResultField> fields = this.processFields(mv);
        MppResultRow row = new MppResultRow();
        row.setFields(fields);
        return row;
    }

    private List<MppResultField> processFields(MultiValue mv) {
        List fieldKeys = MultiValueUtil.getKeys((MultiValue)mv);
        if (fieldKeys.isEmpty()) {
            return this.getResultsFromLiteralMultiValue(mv);
        }
        return this.processFields(mv, fieldKeys);
    }

    private List<MppResultField> getResultsFromLiteralMultiValue(MultiValue mv) {
        return Arrays.stream(mv.unwrap()).map(this::createResultField).collect(Collectors.toList());
    }

    private MppResultField createResultField(Object o) {
        MppResultField field = new MppResultField();
        field.setValue(Objects.isNull(o) ? null : o.toString());
        return field;
    }

    private List<MppResultField> processFields(MultiValue mv, List<String> fieldKeys) {
        return fieldKeys.stream().map(key -> this.convertToField(mv, (String)key)).collect(Collectors.toList());
    }

    private MppResultField convertToField(MultiValue mv, String key) {
        MppResultField field = new MppResultField();
        field.setField(key);
        if (mv.isArray(key)) {
            field.setValues(mv.getStringArray(key));
            return field;
        }
        ValueHolder holder = mv.getHolder(key);
        field.setValue(holder.getString());
        return field;
    }

    private void validateElementData(ExecutionElementIdentifier element) {
        if (ElementType.DOMAIN_OBJECT == element.getType()) {
            this.validateDomainData(element);
        }
    }

    private void validateDomainData(ExecutionElementIdentifier domainElement) {
        if (StringUtils.isEmpty((CharSequence)domainElement.getProfileCode()) || StringUtils.isEmpty((CharSequence)domainElement.getAttributeCode())) {
            throw new IllegalArgumentException("profile code and attribute code are necessary for domain execution");
        }
    }

    public ExecutionServiceImpl(HigsonEngine higsonEngine, EffectiveVersionManager effectiveVersionManager, ContextBuilder contextBuilder, ArgumentsBuilder argumentsBuilder, HyperonThreadPoolProperties threadPoolProperties) {
        this.higsonEngine = higsonEngine;
        this.effectiveVersionManager = effectiveVersionManager;
        this.contextBuilder = contextBuilder;
        this.argumentsBuilder = argumentsBuilder;
        this.threadPoolProperties = threadPoolProperties;
    }
}

