/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pl.decerto.hyperon.rest.execution.ExecutionService;
import pl.decerto.hyperon.rest.execution.api.ExecutionController;
import pl.decerto.hyperon.rest.execution.api.dto.BatchExecutionData;
import pl.decerto.hyperon.rest.execution.api.dto.BatchExecutionResponseDto;
import pl.decerto.hyperon.rest.execution.api.dto.BatchExecutionResult;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionData;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionResponseDto;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionResult;
import pl.decerto.hyperon.rest.execution.api.validator.ExecutionDataValidator;

@RestController
@RequestMapping(value={"/execution"}, consumes={"application/json", "application/x-protobuf"}, produces={"application/json", "application/x-protobuf"})
@Tag(name="Execution", description="Endpoint related to parameter/function execution")
public class ExecutionControllerSpringImpl
implements ExecutionController {
    private static final Logger log = LoggerFactory.getLogger(ExecutionControllerSpringImpl.class);
    private final ExecutionService executionService;
    private final ExecutionDataValidator validator;

    @Override
    @Operation(summary="Execute given parameters/functions/domain object for provided context", description="Deprecated. use 'invoke()' endpoint instead. Returns resolved value from parameters/functions/domain for given context. Parameters and domain objects return ParamValue object, function may return any object, for example String or Integer.")
    @Deprecated
    public List<ExecutionResult> execute(@Valid @RequestBody ExecutionData executionData) {
        log.debug("execute called {}", (Object)executionData);
        List<ExecutionResult> result = this.executionService.execute(executionData);
        log.debug("execution ended, result: {}", result);
        return result;
    }

    @Override
    @Operation(summary="Execute given parameters/functions/domain object for provided context", description="Returns resolved value from parameters/functions/domain for given context. Parameters and domain objects return ParamValue object, function may return any object, for example String or Integer.")
    @PostMapping(value={"/invoke"})
    public ExecutionResponseDto invoke(@RequestBody ExecutionData executionData) {
        log.debug("execute called {}", (Object)executionData);
        this.validator.validate(executionData);
        List<ExecutionResult> result = this.executionService.invoke(executionData);
        log.debug("execution ended, result: {}", result);
        return new ExecutionResponseDto(result);
    }

    @Override
    @Operation(summary="Execute given parameters/functions/domain object for provided context list", description="Returns resolved value from parameters/functions/domain\nfor given context list. Parameters and domain objects return ParamValue object,\nfunction may return any object, for example String or Integer.")
    @PostMapping(value={"/batch-invoke"})
    public BatchExecutionResponseDto batchInvoke(@Valid @RequestBody BatchExecutionData executionData) {
        log.debug("execute called {}", (Object)executionData);
        BatchExecutionResult result = this.executionService.batchInvoke(executionData);
        log.debug("batch execution ended, result: {}", (Object)result);
        return BatchExecutionResponseDto.from(result);
    }

    public ExecutionControllerSpringImpl(ExecutionService executionService, ExecutionDataValidator validator) {
        this.executionService = executionService;
        this.validator = validator;
    }
}

