/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import javax.validation.Valid;
import pl.decerto.hyperon.rest.execution.api.dto.BatchExecutionContext;
import pl.decerto.hyperon.rest.execution.api.dto.EffectiveVersionConfigurationDto;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionElementIdentifier;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BatchExecutionData {
    private static final String ARGUMENT_EXAMPLE = "[true, 3.1, \"argument\"]\n";
    private static final String CONTEXT_LIST = "[\n{ \"id\": \"ctx-1\", \"properties\": [ {\"key\": \"jobNumber\", \"value\":\"100\"}, {\"key\": \"employee.name\", \"value\":\"Joe\"} ] },\n{ \"id\": \"ctx-2\", \"properties\": [ {\"key\": \"jobNumber\", \"value\":\"101\"}, {\"key\": \"employee.name\", \"value\":\"Joe\"} ] }\n]\n";
    @Nullable
    @Valid
    private EffectiveVersionConfigurationDto effectiveVersionConfiguration;
    @NotNull
    @Valid
    @Size(min=1)
    @Schema(description="Collection of id and context properties", example="[\n{ \"id\": \"ctx-1\", \"properties\": [ {\"key\": \"jobNumber\", \"value\":\"100\"}, {\"key\": \"employee.name\", \"value\":\"Joe\"} ] },\n{ \"id\": \"ctx-2\", \"properties\": [ {\"key\": \"jobNumber\", \"value\":\"101\"}, {\"key\": \"employee.name\", \"value\":\"Joe\"} ] }\n]\n")
    private @NotNull @Valid @Size(min=1) List<BatchExecutionContext> ctxList;
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<ExecutionElementIdentifier> elements;
    @Nullable
    @Schema(description="Collection of arguments for function (if requires them). Only types supported by Higson.", example="[true, 3.1, \"argument\"]\n")
    private List<Object> arguments;

    @Nullable
    public EffectiveVersionConfigurationDto getEffectiveVersionConfiguration() {
        return this.effectiveVersionConfiguration;
    }

    public List<BatchExecutionContext> getCtxList() {
        return this.ctxList;
    }

    public List<ExecutionElementIdentifier> getElements() {
        return this.elements;
    }

    @Nullable
    public List<Object> getArguments() {
        return this.arguments;
    }

    public void setEffectiveVersionConfiguration(@Nullable EffectiveVersionConfigurationDto effectiveVersionConfiguration) {
        this.effectiveVersionConfiguration = effectiveVersionConfiguration;
    }

    public void setCtxList(List<BatchExecutionContext> ctxList) {
        this.ctxList = ctxList;
    }

    public void setElements(List<ExecutionElementIdentifier> elements) {
        this.elements = elements;
    }

    public void setArguments(@Nullable List<Object> arguments) {
        this.arguments = arguments;
    }

    public String toString() {
        return "BatchExecutionData(effectiveVersionConfiguration=" + this.getEffectiveVersionConfiguration() + ", ctxList=" + this.getCtxList() + ", elements=" + this.getElements() + ", arguments=" + this.getArguments() + ")";
    }
}

