/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import java.util.List;
import pl.decerto.hyperon.rest.execution.api.dto.BatchExecutionResult;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionElementIdentifier;

public class BatchExecutionResponseDto {
    public static final String RESULT_VALUE_EXAMPLE = "{\n\"results\": [\n{\n\"id\": \"ctx-1\",\n\"element\": {\n\"code\": \"CODE\",\n\"type\": \"PARAMETER\"\n},\n\"resultValue\": [\n{\n\"fields\": [\n{\n\"key\": \"key\",\n\"value\": \"some value\"\n}\n]\n}\n]\n}\n]\n}\n";
    private List<Result> results;

    public static BatchExecutionResponseDto from(BatchExecutionResult executionResult) {
        return new BatchExecutionResponseDto(executionResult.getResults().stream().map(result -> new Result(result.getId(), result.getElement(), result.getResultValue())).toList());
    }

    public List<Result> getResults() {
        return this.results;
    }

    public BatchExecutionResponseDto(List<Result> results) {
        this.results = results;
    }

    public static class Result {
        private String id;
        @Size(min=1)
        private @Size(min=1) ExecutionElementIdentifier element;
        @Schema(example="{\n\"results\": [\n{\n\"id\": \"ctx-1\",\n\"element\": {\n\"code\": \"CODE\",\n\"type\": \"PARAMETER\"\n},\n\"resultValue\": [\n{\n\"fields\": [\n{\n\"key\": \"key\",\n\"value\": \"some value\"\n}\n]\n}\n]\n}\n]\n}\n")
        private Object resultValue;

        public String getId() {
            return this.id;
        }

        public ExecutionElementIdentifier getElement() {
            return this.element;
        }

        public Object getResultValue() {
            return this.resultValue;
        }

        public Result(String id, ExecutionElementIdentifier element, Object resultValue) {
            this.id = id;
            this.element = element;
            this.resultValue = resultValue;
        }
    }
}

