/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.ContextualUtilFunction;
import io.higson.runtime.builtin.implementation.DateToken;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.builtin.utils.IdentifyValueUtil;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.type.AbstractValueHolder;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.types.string.StringHolder;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import org.apache.commons.lang3.StringUtils;

public class AddUtilFunction
extends UtilFunction
implements ContextualUtilFunction {
    public static final String CODE = "add";
    public static final UtilFunction INSTANCE = new AddUtilFunction();
    private static final String PARSE_TEMPORAL_AMOUNT_EXCEPTION_MESSAGE = "Unable to parse temporal amount, provided values are incorrect";

    @Override
    public Object call(HigsonContext ctx, Object[] args) {
        String path = this.getContextPath(converter, args);
        if (args.length < 2) {
            throw this.createHigsonRuntimeException(CODE, "function requires at least two arguments.");
        }
        String appendValue = converter.getString(args[1]);
        Object targetObject = ctx.get(path);
        if (StringUtils.isBlank((CharSequence)appendValue)) {
            return null;
        }
        if (ctx.has(appendValue)) {
            Object appendCtxObj = ctx.get(appendValue);
            return this.addTwoObjectFromCtx(args, targetObject, appendCtxObj);
        }
        return this.add(args, targetObject, appendValue);
    }

    private Object add(Object[] args, Object targetObject, String appendValue) {
        return IdentifyValueUtil.identify(targetObject).flatMap(targetObjectHolder -> IdentifyValueUtil.identify(appendValue).map(otherValueHolder -> this.add(args, targetObject, appendValue, (ValueHolder)targetObjectHolder, (ValueHolder)otherValueHolder))).orElse(null);
    }

    private Object add(Object[] args, Object targetObject, String appendValue, ValueHolder targetObjectHolder, ValueHolder appendValueHolder) {
        AbstractValueHolder date;
        AbstractValueHolder objectNumber;
        if (targetObjectHolder instanceof NumberHolder) {
            objectNumber = (NumberHolder)targetObjectHolder;
            if (appendValueHolder instanceof NumberHolder) {
                NumberHolder appendHolder = (NumberHolder)appendValueHolder;
                return this.add(((NumberHolder)objectNumber).getValue(), appendHolder.getValue());
            }
        }
        if (targetObjectHolder instanceof IntegerHolder) {
            objectNumber = (IntegerHolder)targetObjectHolder;
            if (appendValueHolder instanceof IntegerHolder) {
                IntegerHolder appendHolder = (IntegerHolder)appendValueHolder;
                return this.add(((IntegerHolder)objectNumber).getBigDecimal(), appendHolder.getBigDecimal());
            }
        }
        if (targetObjectHolder instanceof NumberHolder) {
            objectNumber = (NumberHolder)targetObjectHolder;
            if (appendValueHolder instanceof IntegerHolder) {
                IntegerHolder appendHolder = (IntegerHolder)appendValueHolder;
                return this.add(((NumberHolder)objectNumber).getBigDecimal(), appendHolder.getBigDecimal());
            }
        }
        if (targetObjectHolder instanceof IntegerHolder) {
            objectNumber = (IntegerHolder)targetObjectHolder;
            if (appendValueHolder instanceof NumberHolder) {
                NumberHolder appendHolder = (NumberHolder)appendValueHolder;
                return this.add(((IntegerHolder)objectNumber).getBigDecimal(), appendHolder.getBigDecimal());
            }
        }
        if (targetObjectHolder instanceof LocalDateHolder) {
            date = (LocalDateHolder)targetObjectHolder;
            this.validateDateArguments(args);
            return this.add(((LocalDateHolder)date).getValue(), appendValue, converter.getString(args[2]));
        }
        if (targetObjectHolder instanceof LocalDateTimeHolder) {
            date = (LocalDateTimeHolder)targetObjectHolder;
            this.validateDateArguments(args);
            return this.add(((LocalDateTimeHolder)date).getValue(), appendValue, converter.getString(args[2]));
        }
        if (targetObject instanceof String) {
            String text = (String)targetObject;
            return this.add(text, appendValue);
        }
        throw this.createHigsonRuntimeException(CODE, String.format("Cannot add %s to %s, unsupported types", args[0], args[1]));
    }

    private Object addTwoObjectFromCtx(Object[] args, Object targetObject, Object otherObject) {
        return IdentifyValueUtil.identify(targetObject).flatMap(targetObjectHolder -> IdentifyValueUtil.identify(otherObject).map(otherValueHolder -> this.addTwoObjectFromCtx(args, targetObject, otherObject, (ValueHolder)targetObjectHolder, (ValueHolder)otherValueHolder))).orElse(null);
    }

    private Object addTwoObjectFromCtx(Object[] args, Object targetObject, Object otherObject, ValueHolder targetObjectHolder, ValueHolder otherValueHolder) {
        StringHolder text;
        AbstractValueHolder date;
        AbstractValueHolder objectNumber;
        if (targetObjectHolder instanceof NumberHolder) {
            objectNumber = (NumberHolder)targetObjectHolder;
            if (otherValueHolder instanceof NumberHolder) {
                NumberHolder appendHolder = (NumberHolder)otherValueHolder;
                return ((NumberHolder)objectNumber).getValue().add(appendHolder.getValue());
            }
        }
        if (targetObjectHolder instanceof IntegerHolder) {
            objectNumber = (IntegerHolder)targetObjectHolder;
            if (otherValueHolder instanceof IntegerHolder) {
                IntegerHolder appendHolder = (IntegerHolder)otherValueHolder;
                return this.add(((IntegerHolder)objectNumber).getBigDecimal(), appendHolder.getBigDecimal());
            }
        }
        if (targetObjectHolder instanceof LocalDateHolder) {
            date = (LocalDateHolder)targetObjectHolder;
            if (otherValueHolder instanceof LocalDateHolder) {
                LocalDateHolder otherDate = (LocalDateHolder)otherValueHolder;
                this.validateTwoDateArguments(args);
                return this.addDates(((LocalDateHolder)date).getValue(), otherDate.getValue(), args);
            }
        }
        if (targetObjectHolder instanceof LocalDateTimeHolder) {
            date = (LocalDateTimeHolder)targetObjectHolder;
            if (otherValueHolder instanceof LocalDateTimeHolder) {
                LocalDateTimeHolder otherDate = (LocalDateTimeHolder)otherValueHolder;
                this.validateTwoDateArguments(args);
                return this.addDates(((LocalDateTimeHolder)date).getValue(), otherDate.getValue(), args);
            }
        }
        if (targetObjectHolder instanceof StringHolder) {
            text = (StringHolder)targetObjectHolder;
            if (otherValueHolder instanceof StringHolder) {
                StringHolder appendText = (StringHolder)otherValueHolder;
                return this.add(text.getValue(), appendText.getValue());
            }
        }
        if (targetObjectHolder instanceof StringHolder) {
            text = (StringHolder)targetObjectHolder;
            if (!(otherValueHolder instanceof StringHolder)) {
                return this.add(text.getValue(), otherValueHolder.getString());
            }
        }
        throw this.createHigsonRuntimeException(CODE, "Cannot add '" + targetObject + "' to '" + otherObject + "' types do not match");
    }

    private LocalDate addDates(LocalDate target, LocalDate addObject, Object[] args) {
        DateToken token = DateToken.find(converter.getString(args[2]));
        switch (token) {
            case DAY: 
            case YEAR: 
            case MONTH: {
                break;
            }
            default: {
                throw this.createHigsonRuntimeException(CODE, "Unexpected value: " + token);
            }
        }
        return target.plus(this.getPeriodBetween(target, addObject, token));
    }

    private LocalDateTime addDates(LocalDateTime target, LocalDateTime anotherObjInstant, Object[] args) {
        DateToken token = DateToken.find(converter.getString(args[2]));
        return switch (token) {
            default -> throw new IncompatibleClassChangeError();
            case DateToken.SECOND, DateToken.MINUTE, DateToken.HOUR -> target.plus(this.getDurationBetween(target, anotherObjInstant, token));
            case DateToken.DAY, DateToken.YEAR, DateToken.MONTH -> target.plus(this.getPeriodBetween(target, anotherObjInstant, token));
        };
    }

    private TemporalAmount getPeriodBetween(Temporal target, Temporal anotherObject, DateToken token) {
        return switch (token) {
            case DateToken.DAY -> {
                int between = (int)ChronoUnit.DAYS.between(target, anotherObject);
                yield Period.ofDays(between);
            }
            case DateToken.MONTH -> {
                int between = (int)ChronoUnit.MONTHS.between(target, anotherObject);
                yield Period.ofMonths(between);
            }
            case DateToken.YEAR -> {
                int between = (int)ChronoUnit.YEARS.between(target, anotherObject);
                yield Period.ofYears(between);
            }
            default -> throw this.createHigsonRuntimeException(CODE, "Unexpected value: " + token);
        };
    }

    private TemporalAmount getDurationBetween(Temporal target, Temporal anotherObject, DateToken token) {
        return switch (token) {
            case DateToken.SECOND -> {
                int between = (int)ChronoUnit.SECONDS.between(target, anotherObject);
                yield Duration.ofSeconds(between);
            }
            case DateToken.MINUTE -> {
                int between = (int)ChronoUnit.MINUTES.between(target, anotherObject);
                yield Duration.ofMinutes(between);
            }
            case DateToken.HOUR -> {
                int between = (int)ChronoUnit.HOURS.between(target, anotherObject);
                yield Duration.ofHours(between);
            }
            default -> throw new HigsonRuntimeException("Unexpected value: " + token);
        };
    }

    private LocalDateTime add(LocalDateTime date, String appendValue, String timeToken) {
        return this.addToken(date, appendValue, timeToken);
    }

    private LocalDate add(LocalDate date, String appendValue, String timeToken) {
        return this.addToken(date, appendValue, timeToken);
    }

    private String add(String text, String appendValue) {
        if (appendValue == null || StringUtils.isBlank((CharSequence)appendValue)) {
            return text;
        }
        return text + appendValue;
    }

    private BigDecimal add(BigDecimal number, BigDecimal appendValue) {
        return number.add(converter.getDecimal(appendValue));
    }

    private LocalDateTime addToken(LocalDateTime localDateTime, String text, String timeToken) {
        return this.toTemporalAmount(text, timeToken).map(localDateTime::plus).orElseThrow(() -> this.createHigsonRuntimeException(CODE, PARSE_TEMPORAL_AMOUNT_EXCEPTION_MESSAGE));
    }

    private LocalDate addToken(LocalDate localDateTime, String text, String timeToken) {
        return this.toTemporalAmount(text, timeToken).map(localDateTime::plus).orElseThrow(() -> this.createHigsonRuntimeException(CODE, PARSE_TEMPORAL_AMOUNT_EXCEPTION_MESSAGE));
    }

    private void validateDateArguments(Object[] args) {
        if (args.length < 3) {
            throw this.createHigsonRuntimeException(CODE, "date missing time token argument, please provide one of acceptable tokens " + DateToken.ACCEPTABLE_TOKENS);
        }
        if (!this.isValid(args[1], Number.class)) {
            throw this.createHigsonRuntimeException(CODE, "first argument must be a number.");
        }
        if (!this.isValid(args[2], String.class)) {
            throw this.createHigsonRuntimeException(CODE, "second argument must be a time token. Acceptable values are " + DateToken.ACCEPTABLE_TOKENS);
        }
    }

    private void validateTwoDateArguments(Object[] args) {
        if (args.length < 3) {
            throw this.createHigsonRuntimeException(CODE, "date missing time token argument, please provide one of acceptable tokens " + DateToken.ACCEPTABLE_TOKENS);
        }
        if (!this.isValid(args[2], String.class)) {
            throw this.createHigsonRuntimeException(CODE, "second argument must be a time token. Acceptable values are " + DateToken.ACCEPTABLE_TOKENS);
        }
    }

    private AddUtilFunction() {
    }
}

