/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;

enum DateToken {
    SECOND("s", "seconds"),
    MINUTE("m", "minutes"),
    HOUR("h", "hours"),
    DAY("d", "days"),
    MONTH("M", "months"),
    YEAR("Y", "years");

    private static final String[] SHORT_TOKENS;
    private static final String[] FULL_TOKENS;
    public static final String ACCEPTABLE_TOKENS;
    private final String shortToken;
    private final String fullToken;

    static DateToken find(String text) {
        for (DateToken token : DateToken.values()) {
            if (!token.shortToken.equals(text) && !token.fullToken.equalsIgnoreCase(text)) continue;
            return token;
        }
        throw new IllegalArgumentException("Unrecognized token: " + text + ", allowed values: " + Arrays.toString(FULL_TOKENS) + " or " + Arrays.toString(SHORT_TOKENS));
    }

    TemporalAmount toTemporalAmount(int amount) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SECOND -> Duration.ofSeconds(amount);
            case MINUTE -> Duration.ofMinutes(amount);
            case HOUR -> Duration.ofHours(amount);
            case DAY -> Period.ofDays(amount);
            case MONTH -> Period.ofMonths(amount);
            case YEAR -> Period.ofYears(amount);
        };
    }

    private DateToken(String shortToken, String fullToken) {
        this.shortToken = shortToken;
        this.fullToken = fullToken;
    }

    static {
        SHORT_TOKENS = (String[])Arrays.stream(DateToken.values()).map(token -> token.shortToken).toArray(String[]::new);
        FULL_TOKENS = (String[])Arrays.stream(DateToken.values()).map(token -> token.fullToken).toArray(String[]::new);
        ACCEPTABLE_TOKENS = Arrays.toString(FULL_TOKENS) + " or " + Arrays.toString(SHORT_TOKENS);
    }
}

