/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.ContextualUtilFunction;
import io.higson.runtime.builtin.implementation.DateToken;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.builtin.utils.IdentifyValueUtil;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.type.AbstractValueHolder;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.types.string.StringHolder;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.rhino.RhinoUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class DiffUtilFunction
extends UtilFunction
implements ContextualUtilFunction {
    public static final String CODE = "diff";
    public static final UtilFunction INSTANCE = new DiffUtilFunction();
    private static final String PARSE_TEMPORAL_AMOUNT_EXCEPTION_MESSAGE = "Unable to parse temporal amount, provided values are incorrect";

    @Override
    public Object call(HigsonContext ctx, Object[] args) {
        String path = this.getContextPath(converter, args);
        Object targetObject = ctx.get(path);
        if (args.length < 2) {
            throw this.createHigsonRuntimeException(CODE, "requires at least two arguments.");
        }
        String diff = converter.getString(args[1]);
        if (RhinoUtil.isBlank(diff)) {
            return null;
        }
        if (ctx.has(diff)) {
            Object diffObj = ctx.get(diff);
            return this.getDiffBetweenTwoObjectInCtx(args, targetObject, diffObj);
        }
        return this.getDiff(args, targetObject, diff);
    }

    private Object getDiff(Object[] args, Object targetObject, String otherObject) {
        return IdentifyValueUtil.identify(targetObject).flatMap(targetObjectHolder -> IdentifyValueUtil.identify(otherObject).map(otherValueHolder -> this.compare(args, otherObject, (ValueHolder)targetObjectHolder, (ValueHolder)otherValueHolder))).orElse(null);
    }

    private Object compare(Object[] args, String otherObject, ValueHolder targetObjectHolder, ValueHolder otherValueHolder) {
        if (targetObjectHolder instanceof NumberHolder && otherValueHolder instanceof NumberHolder) {
            return targetObjectHolder.getBigDecimal().subtract(otherValueHolder.getBigDecimal());
        }
        if (targetObjectHolder instanceof IntegerHolder && otherValueHolder instanceof IntegerHolder) {
            return targetObjectHolder.getInteger() - otherValueHolder.getInteger();
        }
        if (targetObjectHolder instanceof NumberHolder && otherValueHolder instanceof IntegerHolder) {
            return targetObjectHolder.getInteger() - otherValueHolder.getInteger();
        }
        if (targetObjectHolder instanceof IntegerHolder && otherValueHolder instanceof NumberHolder) {
            return targetObjectHolder.getInteger() - otherValueHolder.getInteger();
        }
        if (targetObjectHolder instanceof LocalDateHolder) {
            LocalDateHolder date = (LocalDateHolder)targetObjectHolder;
            this.validateDateArguments(args);
            return this.diff(date.getValue(), otherObject, converter.getString(args[2]));
        }
        if (targetObjectHolder instanceof LocalDateTimeHolder) {
            LocalDateTimeHolder date = (LocalDateTimeHolder)targetObjectHolder;
            this.validateDateArguments(args);
            return this.diff(date.getValue(), otherObject, converter.getString(args[2]));
        }
        if (targetObjectHolder instanceof StringHolder) {
            StringHolder text = (StringHolder)targetObjectHolder;
            return this.diff(text.getValue(), otherObject);
        }
        if (targetObjectHolder instanceof StringHolder && !(otherValueHolder instanceof StringHolder)) {
            return this.diff(targetObjectHolder.getString(), otherValueHolder.getString());
        }
        throw this.createHigsonRuntimeException(CODE, String.format("'%s' and '%s' must be compatible type", args[0], args[1]));
    }

    private Object getDiffBetweenTwoObjectInCtx(Object[] args, Object targetObject, Object otherObject) {
        return IdentifyValueUtil.identify(targetObject).flatMap(targetObjectHolder -> IdentifyValueUtil.identify(otherObject).map(otherValueHolder -> this.compareTwoCtxObject(args, (ValueHolder)targetObjectHolder, (ValueHolder)otherValueHolder))).orElse(null);
    }

    private Object compareTwoCtxObject(Object[] args, ValueHolder targetObjectHolder, ValueHolder otherValueHolder) {
        AbstractValueHolder date;
        if (targetObjectHolder instanceof NumberHolder && otherValueHolder instanceof NumberHolder) {
            return targetObjectHolder.getInteger() - otherValueHolder.getInteger();
        }
        if (targetObjectHolder instanceof IntegerHolder && otherValueHolder instanceof IntegerHolder) {
            return targetObjectHolder.getBigDecimal().subtract(otherValueHolder.getBigDecimal());
        }
        if (targetObjectHolder instanceof LocalDateTimeHolder) {
            date = (LocalDateTimeHolder)targetObjectHolder;
            if (otherValueHolder instanceof LocalDateTimeHolder) {
                LocalDateTimeHolder diffDate = (LocalDateTimeHolder)otherValueHolder;
                this.validateTwoDateArguments(args);
                return this.diffDates(((LocalDateTimeHolder)date).getValue(), diffDate.getValue(), args);
            }
        }
        if (targetObjectHolder instanceof LocalDateHolder) {
            date = (LocalDateHolder)targetObjectHolder;
            if (otherValueHolder instanceof LocalDateHolder) {
                LocalDateHolder diffDate = (LocalDateHolder)otherValueHolder;
                this.validateTwoDateArguments(args);
                return this.diffDates(((LocalDateHolder)date).getValue(), diffDate.getValue(), args);
            }
        }
        if (targetObjectHolder instanceof StringHolder) {
            StringHolder text = (StringHolder)targetObjectHolder;
            if (otherValueHolder instanceof StringHolder) {
                StringHolder diffText = (StringHolder)otherValueHolder;
                return this.diff(text.getValue(), diffText.getValue());
            }
        }
        throw this.createHigsonRuntimeException(CODE, "Cannot get differance between '" + targetObjectHolder.getValue() + "' and '" + otherValueHolder.getValue() + "' types do not match");
    }

    private Long diffDates(LocalDate date, LocalDate diffDate, Object[] args) {
        DateToken token = DateToken.find(converter.getString(args[2]));
        return switch (token) {
            case DateToken.DAY -> ChronoUnit.DAYS.between(date, diffDate);
            case DateToken.MONTH -> ChronoUnit.MONTHS.between(date, diffDate);
            case DateToken.YEAR -> ChronoUnit.YEARS.between(date, diffDate);
            default -> throw new HigsonRuntimeException("Unexpected value: " + token);
        };
    }

    private Long diffDates(LocalDateTime date, LocalDateTime diffDate, Object[] args) {
        DateToken token = DateToken.find(converter.getString(args[2]));
        return switch (token) {
            default -> throw new IncompatibleClassChangeError();
            case DateToken.SECOND -> ChronoUnit.SECONDS.between(date, diffDate);
            case DateToken.MINUTE -> ChronoUnit.MINUTES.between(date, diffDate);
            case DateToken.HOUR -> ChronoUnit.HOURS.between(date, diffDate);
            case DateToken.DAY -> ChronoUnit.DAYS.between(date, diffDate);
            case DateToken.MONTH -> ChronoUnit.MONTHS.between(date, diffDate);
            case DateToken.YEAR -> ChronoUnit.YEARS.between(date, diffDate);
        };
    }

    private LocalDateTime diff(LocalDateTime date, String diff, String timeToken) {
        return this.diffToken(date, diff, timeToken);
    }

    private LocalDate diff(LocalDate date, String diff, String timeToken) {
        return this.diffToken(date, diff, timeToken);
    }

    private String diff(String text, String replacementText) {
        if (replacementText == null || RhinoUtil.isBlank(replacementText)) {
            return text;
        }
        return text.replace(replacementText, "");
    }

    private LocalDateTime diffToken(LocalDateTime localDateTime, String text, String timeToken) {
        return this.toTemporalAmount(text, timeToken).map(localDateTime::minus).orElseThrow(() -> this.createHigsonRuntimeException(CODE, PARSE_TEMPORAL_AMOUNT_EXCEPTION_MESSAGE));
    }

    private LocalDate diffToken(LocalDate localDate, String text, String timeToken) {
        return this.toTemporalAmount(text, timeToken).map(localDate::minus).orElseThrow(() -> this.createHigsonRuntimeException(CODE, PARSE_TEMPORAL_AMOUNT_EXCEPTION_MESSAGE));
    }

    private void validateDateArguments(Object[] args) {
        if (args.length < 3) {
            throw this.createHigsonRuntimeException(CODE, "date missing time token argument, please provide one of acceptable tokens " + DateToken.ACCEPTABLE_TOKENS);
        }
        if (!this.isValid(args[1], Number.class)) {
            throw this.createHigsonRuntimeException(CODE, "first argument must be a number.");
        }
        if (!this.isValid(args[2], String.class)) {
            throw this.createHigsonRuntimeException(CODE, "second argument must be a time token. Acceptable values are " + DateToken.ACCEPTABLE_TOKENS);
        }
    }

    private void validateTwoDateArguments(Object[] args) {
        if (args.length < 3) {
            throw this.createHigsonRuntimeException(CODE, "date missing time token argument, please provide one of acceptable tokens " + DateToken.ACCEPTABLE_TOKENS);
        }
        if (!this.isValid(args[2], String.class)) {
            throw this.createHigsonRuntimeException(CODE, "second argument must be a time token. Acceptable values are " + DateToken.ACCEPTABLE_TOKENS);
        }
    }

    private DiffUtilFunction() {
    }
}

