/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.ContextualUtilFunction;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.util.List;

public class FromUtilFunction
extends UtilFunction
implements ContextualUtilFunction {
    public static final String CODE = "from";
    public static final FromUtilFunction INSTANCE = new FromUtilFunction();
    private static final String INDEX = "index";

    @Override
    public Object call(HigsonContext ctx, Object[] args) {
        String path = this.getContextPath(converter, args);
        Object target = ctx.get(path);
        return this.from(args, target);
    }

    private Object from(Object[] args, Object targetObject) {
        if (args.length < 2) {
            throw this.createMissingValueException("Second argument is required");
        }
        if (targetObject instanceof List) {
            List list = (List)targetObject;
            return this.handleList(args, list);
        }
        if (targetObject == null) {
            return null;
        }
        if (targetObject instanceof String) {
            String text = (String)targetObject;
            return this.handleString(args, text);
        }
        throw this.createUnsupportedTypeException(targetObject);
    }

    private String handleString(Object[] args, String text) {
        if (text.isEmpty()) {
            return text;
        }
        Integer index = converter.getInteger(args[1]);
        if (index == null) {
            throw this.createMissingValueException(INDEX);
        }
        return text.substring(index);
    }

    private Object handleList(Object[] args, List<Object> list) {
        if (!list.isEmpty()) {
            Integer index = converter.getInteger(args[1]);
            if (index == null) {
                throw this.createMissingValueException(INDEX);
            }
            if (index < 0 || index >= list.size()) {
                throw this.createHigsonRuntimeException(CODE, "Invalid index");
            }
            return list.subList(index, list.size());
        }
        return null;
    }

    private HigsonRuntimeException createUnsupportedTypeException(Object target) {
        return this.createHigsonRuntimeException(CODE, "Unsupported type " + target.getClass().getSimpleName());
    }

    private HigsonRuntimeException createMissingValueException(String value) {
        return this.createHigsonRuntimeException(CODE, "Missing " + value);
    }

    private FromUtilFunction() {
    }
}

