/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.ContextualUtilFunction;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.builtin.utils.IdentifyValueUtil;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.type.AbstractValueHolder;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.types.string.StringHolder;

public class GreaterThanEqualsUtilFunction
extends UtilFunction
implements ContextualUtilFunction {
    public static final String CODE = "gte";
    public static final UtilFunction INSTANCE = new GreaterThanEqualsUtilFunction();

    @Override
    public Object call(HigsonContext ctx, Object[] args) {
        String path = this.getContextPath(converter, args);
        Object targetObject = ctx.get(path);
        if (args.length < 2) {
            throw this.createHigsonRuntimeException(CODE, "requires at least two arguments.");
        }
        return this.isGreaterThanOrEquals(args, targetObject);
    }

    private Object isGreaterThanOrEquals(Object[] args, Object targetObject) {
        Object otherObject = args[1];
        return IdentifyValueUtil.identify(targetObject).flatMap(targetObjectHolder -> IdentifyValueUtil.identify(otherObject).map(otherValueHolder -> this.compare((ValueHolder)targetObjectHolder, (ValueHolder)otherValueHolder, otherObject))).orElse(null);
    }

    private Object compare(ValueHolder targetObjectHolder, ValueHolder otherValueHolder, Object otherObject) {
        AbstractValueHolder targetHolder;
        if (targetObjectHolder instanceof NumberHolder) {
            targetHolder = (NumberHolder)targetObjectHolder;
            if (otherValueHolder instanceof NumberHolder) {
                NumberHolder otherHolder = (NumberHolder)otherValueHolder;
                return ((NumberHolder)targetHolder).getValue().compareTo(otherHolder.getValue()) >= 0;
            }
        }
        if (targetObjectHolder instanceof IntegerHolder) {
            targetHolder = (IntegerHolder)targetObjectHolder;
            if (otherValueHolder instanceof IntegerHolder) {
                IntegerHolder otherHolder = (IntegerHolder)otherValueHolder;
                return ((IntegerHolder)targetHolder).getValue() >= otherHolder.getValue();
            }
        }
        if (targetObjectHolder instanceof StringHolder) {
            targetHolder = (StringHolder)targetObjectHolder;
            if (otherValueHolder instanceof StringHolder) {
                StringHolder otherHolder = (StringHolder)otherValueHolder;
                return ((StringHolder)targetHolder).getValue().compareTo(otherHolder.getValue()) >= 0;
            }
        }
        if (targetObjectHolder instanceof LocalDateHolder) {
            targetHolder = (LocalDateHolder)targetObjectHolder;
            if (otherValueHolder instanceof LocalDateHolder) {
                LocalDateHolder otherHolder = (LocalDateHolder)otherValueHolder;
                return !((LocalDateHolder)targetHolder).getValue().isBefore(otherHolder.getValue());
            }
        }
        if (targetObjectHolder instanceof LocalDateTimeHolder) {
            targetHolder = (LocalDateTimeHolder)targetObjectHolder;
            if (otherValueHolder instanceof LocalDateTimeHolder) {
                LocalDateTimeHolder otherHolder = (LocalDateTimeHolder)otherValueHolder;
                return !((LocalDateTimeHolder)targetHolder).getValue().isBefore(otherHolder.getValue());
            }
        }
        throw this.createHigsonRuntimeException(CODE, "Cannot compare '" + targetObjectHolder.getValue() + "' to '" + otherObject + "' types do not match");
    }

    private GreaterThanEqualsUtilFunction() {
    }
}

