/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.ContextualUtilFunction;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.util.Collection;

public class ToUtilFunction
extends UtilFunction
implements ContextualUtilFunction {
    public static final String CODE = "to";
    public static final ToUtilFunction INSTANCE = new ToUtilFunction();
    private static final String INDEX = "index";
    private static final String KEY = "key";

    @Override
    public Object call(HigsonContext ctx, Object[] args) {
        String path = this.getContextPath(converter, args);
        Object target = ctx.get(path);
        return this.to(args, target);
    }

    private Object to(Object[] args, Object targetObject) {
        if (targetObject == null) {
            return null;
        }
        if (args.length < 2) {
            throw this.createMissingValueException("Second argument is required");
        }
        if (targetObject instanceof String) {
            String str = (String)targetObject;
            return this.handleString(args, str);
        }
        if (targetObject instanceof Collection) {
            Collection collection = (Collection)targetObject;
            return this.handleList(args, collection);
        }
        throw this.createUnsupportedTypeException(targetObject);
    }

    private String handleString(Object[] args, String text) {
        if (text.isEmpty()) {
            return text;
        }
        Integer index = converter.getInteger(args[1]);
        if (index == null) {
            throw this.createMissingValueException(INDEX);
        }
        return text.substring(0, index);
    }

    private Object handleList(Object[] args, Collection collection) {
        if (!collection.isEmpty()) {
            Integer index = converter.getInteger(args[1]);
            if (index == null) {
                throw this.createMissingValueException(INDEX);
            }
            if (index < 0 || index >= collection.size()) {
                throw this.createHigsonRuntimeException(CODE, "Invalid index");
            }
            return collection.stream().toList().subList(0, index);
        }
        return null;
    }

    private HigsonRuntimeException createUnsupportedTypeException(Object target) {
        return this.createHigsonRuntimeException(CODE, "Unsupported type " + target.getClass().getSimpleName());
    }

    private HigsonRuntimeException createMissingValueException(String value) {
        return this.createHigsonRuntimeException(CODE, "Missing " + value);
    }

    private ToUtilFunction() {
    }
}

