/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.DateToken;
import io.higson.runtime.builtin.utils.IdentifyValueUtil;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.helper.TypeConverter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import java.util.Optional;

public abstract class UtilFunction {
    protected static final TypeConverter converter = TypeConverter.getInstance();

    public abstract Object call(HigsonContext var1, Object[] var2);

    protected <T> boolean isValid(Object object, Class<T> type) {
        try {
            if (type.isInstance(object)) {
                return this.convert(object, type) != null;
            }
            if (object instanceof String && Number.class.isAssignableFrom(type)) {
                return converter.getDecimal(object) != null;
            }
            if (object instanceof String && Boolean.class.isAssignableFrom(type)) {
                return converter.getBoolean(object);
            }
            if (Date.class.isAssignableFrom(type) && object instanceof Date) {
                return true;
            }
            if (LocalDate.class.isAssignableFrom(type) && object instanceof LocalDate) {
                return true;
            }
            return LocalDateTime.class.isAssignableFrom(type) && object instanceof LocalDateTime;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Optional<TemporalAmount> toTemporalAmount(String text, String token) {
        ValueHolder valueHolder;
        Optional<ValueHolder> holder = IdentifyValueUtil.identify(text);
        if (holder.isPresent() && (valueHolder = holder.get()) instanceof IntegerHolder) {
            IntegerHolder number = (IntegerHolder)valueHolder;
            TemporalAmount temporalAmount = DateToken.find(token).toTemporalAmount(number.getInteger());
            return Optional.of(temporalAmount);
        }
        return Optional.empty();
    }

    private <T> T convert(Object object, Class<T> type) {
        if (type.equals(Date.class)) {
            return (T)converter.getDate(object);
        }
        if (type.equals(LocalDate.class)) {
            return (T)converter.getLocalDate(object);
        }
        if (type.equals(LocalDateTime.class)) {
            return (T)converter.getLocalDateTime(object);
        }
        if (type.equals(Number.class)) {
            return (T)Double.valueOf(converter.getNumber(object));
        }
        if (type.equals(BigDecimal.class)) {
            return (T)converter.getDecimal(object);
        }
        if (type.equals(String.class)) {
            return (T)converter.getString(object);
        }
        return null;
    }

    protected HigsonRuntimeException createHigsonRuntimeException(String code, String message) {
        return new HigsonRuntimeException("Util function '" + code + "': " + message);
    }

    protected HigsonRuntimeException createHigsonRuntimeException(String code, String message, RuntimeException reason) {
        return new HigsonRuntimeException("Util function '" + code + "': " + message, reason);
    }
}

