/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import io.higson.runtime.core.datasource.snapshot.domain.DomainAttributeMapper;
import io.higson.runtime.core.datasource.snapshot.domain.DomainElementAttributesWrapper;
import io.higson.runtime.core.datasource.snapshot.domain.DomainExtraAttributeMapper;
import io.higson.runtime.core.datasource.snapshot.domain.DomainWrapper;
import io.higson.runtime.core.datasource.snapshot.domain.SnapshotModelConverter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.mpp.imports.xml.domain.DomainAttributes;
import pl.decerto.mpp.imports.xml.domain.DomainElement;
import pl.decerto.mpp.imports.xml.domain.DomainExtraAttributes;

public class AttributeProcessor {
    private static final Logger log = LoggerFactory.getLogger(AttributeProcessor.class);
    private final SnapshotModelConverter<DomainElementAttributesWrapper> converter;

    public void process(DomainWrapper domainWrapper, Path file) throws IOException {
        DomainElementAttributesWrapper model;
        try {
            model = this.converter.createModel(file);
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        DomainElement domainElement = domainWrapper.getDomainElement();
        if (domainElement.getDomainAttributes() == null && CollectionUtils.isNotEmpty(model.getAttr())) {
            DomainAttributes domainAttributes = new DomainAttributes();
            domainAttributes.getDomainAttribute().addAll(DomainAttributeMapper.transformFrom(model.getAttr()));
            domainElement.setDomainAttributes(domainAttributes);
        }
        if (domainElement.getDomainExtraAttrs() == null && CollectionUtils.isNotEmpty(model.getLocalAttr())) {
            DomainExtraAttributes extraAttributes = new DomainExtraAttributes();
            extraAttributes.getDomainExtraAttr().addAll(DomainExtraAttributeMapper.transformFrom(model.getLocalAttr()));
            domainElement.setDomainExtraAttrs(extraAttributes);
        }
    }

    public AttributeProcessor(SnapshotModelConverter<DomainElementAttributesWrapper> converter) {
        this.converter = converter;
    }
}

