/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import java.util.Optional;
import pl.decerto.mpp.imports.xml.domain.DomainDefinition;
import pl.decerto.mpp.imports.xml.domain.DomainType;
import pl.decerto.mpp.imports.xml.domain.DomainTypeCollection;

public class DomainDefinitionXmlHelper {
    private final DomainDefinition domainDefinitionXml;

    public DomainDefinitionXmlHelper(DomainDefinition domainDefinitionXml) {
        this.domainDefinitionXml = domainDefinitionXml;
    }

    public DomainType findRoot() {
        return this.domainDefinitionXml.getDomainTypes().getDomainType().stream().filter(DomainType::isRootType).findFirst().orElseThrow(() -> new IllegalArgumentException("Missing root"));
    }

    public Optional<DomainTypeCollection> getDomainTypeCollection(DomainType domainType, String typeCollectionCode) {
        if (domainType.getTypeCollections() == null) {
            return Optional.empty();
        }
        return domainType.getTypeCollections().getTypeCollection().stream().filter(f -> f.getCode().equals(typeCollectionCode)).findFirst();
    }

    public DomainType getDomainTypeBasedOnTypeCode(DomainTypeCollection domainTypeCollection) {
        String code = domainTypeCollection.getCollectionTypeCode();
        return this.getDomainType(code);
    }

    public DomainType getDomainType(String code) {
        return this.domainDefinitionXml.getDomainTypes().getDomainType().stream().filter(def -> def.getCode().equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Missing def in domain definition for: %s", code)));
    }
}

