/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import io.higson.runtime.core.datasource.snapshot.SnapshotPath;
import io.higson.runtime.core.datasource.snapshot.domain.AttributeType;
import io.higson.runtime.core.datasource.snapshot.domain.CollectionElement;
import io.higson.runtime.core.datasource.snapshot.domain.Domain;
import io.higson.runtime.core.datasource.snapshot.domain.DomainDefinitionXmlHelper;
import io.higson.runtime.core.datasource.snapshot.domain.DomainDirectoryAnalyzer;
import io.higson.runtime.core.datasource.snapshot.domain.DomainReaderVisitor;
import io.higson.runtime.core.datasource.snapshot.domain.DomainReaderVisitorImpl;
import io.higson.runtime.core.datasource.snapshot.domain.Element;
import io.higson.runtime.core.datasource.snapshot.domain.ElementAttribute;
import io.higson.runtime.core.datasource.snapshot.domain.ElementAttributeExtra;
import io.higson.runtime.core.datasource.snapshot.domain.ReferenceElement;
import io.higson.runtime.core.datasource.snapshot.helper.SnapshotDataSourceConstants;
import io.higson.runtime.core.datasource.snapshot.reader.SnapshotReader;
import io.higson.runtime.helper.snapshot.DomainXMLUtils;
import io.higson.runtime.helper.snapshot.FileSystemSnapshotHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.mpp.imports.xml.domain.DomainAttribute;
import pl.decerto.mpp.imports.xml.domain.DomainAttributes;
import pl.decerto.mpp.imports.xml.domain.DomainDefinition;
import pl.decerto.mpp.imports.xml.domain.DomainElement;
import pl.decerto.mpp.imports.xml.domain.DomainElements;
import pl.decerto.mpp.imports.xml.domain.DomainExtraAttribute;
import pl.decerto.mpp.imports.xml.domain.DomainExtraAttributes;
import pl.decerto.mpp.imports.xml.domain.DomainType;
import pl.decerto.mpp.imports.xml.domain.DomainTypeAttributes;
import pl.decerto.mpp.imports.xml.domain.DomainTypeCollection;
import pl.decerto.mpp.imports.xml.domain.Reference;

public class SnapshotDomainDirReader {
    private static final Logger log = LoggerFactory.getLogger(SnapshotDomainDirReader.class);
    private static final String DEFINITION_EXTENSION = ".xml";
    private final AtomicInteger typeIdGenerator = new AtomicInteger(100);
    private final AtomicInteger collIdGenerator = new AtomicInteger(200);
    private final AtomicInteger eleIdGenerator = new AtomicInteger(300);
    private final Map<String, Domain> domains = new HashMap<String, Domain>();
    private final Set<String> loaded = new HashSet<String>();
    private final SnapshotReader snapshotReader;
    private final File domainsDir;
    private final File snapDir;

    public SnapshotDomainDirReader(File snapshotPath, SnapshotReader snapshotReader) {
        this.snapDir = snapshotPath;
        this.domainsDir = new File(snapshotPath, SnapshotPath.DOMAINS.getPath());
        this.snapshotReader = snapshotReader;
    }

    public Domain getDomain(String profile) {
        this.load(profile);
        return this.domains.get(profile);
    }

    public List<CollectionElement> getCollectionElements(String profile) {
        this.load(profile);
        return this.domains.get(profile).collections();
    }

    public List<Element> getElements(String profileCode) {
        this.load(profileCode);
        return this.domains.get(profileCode).elements();
    }

    private void load(String profile) {
        if (!this.loaded.contains(profile)) {
            DomainDefinition definitionXml = this.getDomainDefinitionXmlZip(profile);
            Map<Integer, DomainType> typesById = this.getTypesById(definitionXml);
            List<CollectionElement> collections = this.buildCollection(definitionXml, typesById);
            Pair<List<Element>, List<ReferenceElement>> elements = this.buildElementsFinal(definitionXml.getDomainElements(), collections);
            Domain domain = Domain.builder().types(SnapshotDomainDirReader.getTypes(definitionXml)).typesById(typesById).collections(collections).elements((List)elements.getLeft()).referenceElements((List)elements.getRight()).build();
            this.domains.put(profile, domain);
            this.loaded.add(profile);
        }
    }

    private Map<Integer, DomainType> getTypesById(DomainDefinition domainDefinitionXml) {
        if (domainDefinitionXml.getDomainTypes() != null) {
            return domainDefinitionXml.getDomainTypes().getDomainType().stream().collect(Collectors.toMap(type -> this.typeIdGenerator.getAndIncrement(), Function.identity()));
        }
        return Collections.emptyMap();
    }

    private List<CollectionElement> buildCollection(DomainDefinition domainDefinitionXml, Map<Integer, DomainType> typesById) {
        return domainDefinitionXml.getDomainTypes().getDomainType().stream().map(domainType -> this.buildType((DomainType)domainType, typesById)).flatMap(Collection::stream).toList();
    }

    private DomainDefinition getDomainDefinitionXmlZip(String profile) {
        DomainDefinition domainDefinition;
        block8: {
            ReaderInputStream inputStream = this.getReaderInputStream(profile);
            try {
                DomainDefinition domainDefinitionXml = DomainXMLUtils.getDomain((InputStream)inputStream);
                DomainReaderVisitor<Path> visitor = this.buildDomainFileSystemVisitor(Path.of(this.domainsDir.getPath(), profile), domainDefinitionXml);
                Path domainConfigurationPath = this.snapshotReader.getPath(this.snapDir.toPath(), SnapshotPath.DOMAINS.getPath() + SnapshotDataSourceConstants.PATH_SEPARATOR + profile + SnapshotDataSourceConstants.PATH_SEPARATOR + SnapshotPath.DOMAIN_CONF.getPath());
                log.debug("Path to configuration is: {} and start analyzing this path", (Object)domainConfigurationPath);
                Files.walkFileTree(domainConfigurationPath, visitor);
                DomainElements elements = new DomainElements();
                elements.getDomainElement().addAll(visitor.getDomainElements());
                log.debug("Finished walking on domain configuration tree with number of root elements: {}", (Object)elements.getDomainElement().size());
                domainDefinitionXml.setDomainElements(elements);
                domainDefinition = domainDefinitionXml;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return domainDefinition;
    }

    private ReaderInputStream getReaderInputStream(String profile) {
        try {
            Path path = Path.of(SnapshotPath.DOMAINS.getPath() + SnapshotDataSourceConstants.PATH_SEPARATOR + profile + SnapshotDataSourceConstants.PATH_SEPARATOR + SnapshotPath.DOMAIN_DEF.getPath() + SnapshotDataSourceConstants.PATH_SEPARATOR + profile + DEFINITION_EXTENSION, new String[0]);
            Reader reader = this.snapshotReader.getReader(this.snapDir, path);
            return ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(reader)).get();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Pair<List<Element>, List<ReferenceElement>> buildElementsFinal(DomainElements elements, List<CollectionElement> collections) {
        if (elements.getDomainElement() == null) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList result = new ArrayList();
        ArrayList referenceElements = new ArrayList();
        elements.getDomainElement().forEach(element -> this.addElement(null, (DomainElement)element, result, referenceElements, null, collections));
        return Pair.of(result, referenceElements);
    }

    private void addElement(DomainElement parent, DomainElement child, List<Element> result, List<ReferenceElement> references, Element parentEle, List<CollectionElement> collections) {
        Element element = Element.builder().id(this.eleIdGenerator.getAndIncrement()).parentId(parentEle != null ? Integer.valueOf(parentEle.id()) : null).path((parentEle != null ? parentEle.path() : "") + "/" + child.getCollectionTypeCode() + "[" + child.getCode() + "]").code(child.getCode()).name(child.getName()).description(child.getDescription()).type(this.findCollectionElement(parent, child, collections)).regionCode(child.getRegionCode()).versionNumber(child.getVersionNumber()).extraAttributes(this.buildExtraAttributes(child.getDomainExtraAttrs())).attributes(this.buildAttributes(child.getDomainAttributes())).build();
        result.add(element);
        if (child.getReferences() != null) {
            child.getReferences().getReference().forEach(reference -> references.add(ReferenceElement.builder().path(reference.getPath()).parentId(element.id()).collectionId(SnapshotDomainDirReader.getCollectionElement(collections, reference).id()).parentCollectionCode(reference.getCollectionCode()).build()));
        }
        if (child.getChildren() != null) {
            child.getChildren().getChildElement().forEach(domainElement -> this.addElement(child, (DomainElement)domainElement, result, references, element, collections));
        }
    }

    private static CollectionElement getCollectionElement(List<CollectionElement> collections, Reference reference) {
        return collections.stream().filter(e -> e.code().equals(reference.getCollectionCode())).findAny().orElseThrow(() -> new IllegalStateException("Cannot find collection element " + reference.getCollectionCode()));
    }

    private List<ElementAttribute> buildAttributes(DomainAttributes domainExtraAttrs) {
        if (domainExtraAttrs == null) {
            return Collections.emptyList();
        }
        return domainExtraAttrs.getDomainAttribute().stream().map(this::buildAttribute).toList();
    }

    private ElementAttribute buildAttribute(DomainAttribute attribute) {
        return ElementAttribute.builder().attrCode(attribute.getAttributeCode()).refName(attribute.getRefName()).refType(attribute.getRefType().value()).build();
    }

    private List<ElementAttributeExtra> buildExtraAttributes(DomainExtraAttributes domainExtraAttrs) {
        if (domainExtraAttrs == null) {
            return Collections.emptyList();
        }
        return domainExtraAttrs.getDomainExtraAttr().stream().map(this::buildExtraAttribute).toList();
    }

    private ElementAttributeExtra buildExtraAttribute(DomainExtraAttribute domainExtraAttribute) {
        return ElementAttributeExtra.builder().attrCode(domainExtraAttribute.getCode()).attrName(domainExtraAttribute.getName()).attrValue(domainExtraAttribute.getAttrValue()).refType(domainExtraAttribute.getRefType().value()).build();
    }

    private CollectionElement findCollectionElement(DomainElement parent, DomainElement child, List<CollectionElement> collections) {
        if (parent != null) {
            return collections.stream().filter(element -> Objects.equals(element.parentTypeCode(), parent.getCollectionTypeCode())).filter(element -> Objects.equals(element.typeCode(), child.getCollectionTypeCode())).filter(element -> Objects.equals(element.code(), child.getCollectionCode())).findAny().orElseThrow();
        }
        return collections.stream().filter(t -> Objects.equals(t.typeCode(), child.getCollectionTypeCode())).findAny().orElseThrow();
    }

    private List<CollectionElement> buildType(DomainType domainType, Map<Integer, DomainType> typesById) {
        if (domainType.getTypeCollections() == null) {
            return Collections.emptyList();
        }
        return domainType.getTypeCollections().getTypeCollection().stream().map(col -> this.buildCollectionElement(domainType, (DomainTypeCollection)col, typesById)).toList();
    }

    private CollectionElement buildCollectionElement(DomainType t, DomainTypeCollection coll, Map<Integer, DomainType> typesById) {
        Map.Entry<Integer, DomainType> typeId = this.findTypeId(coll.getCollectionTypeCode(), typesById);
        return CollectionElement.builder().id(this.collIdGenerator.getAndIncrement()).code(coll.getCode()).name(coll.getName()).collectionTypeId(typeId.getKey()).typeCode(coll.getCollectionTypeCode()).typeId(this.findTypeId(t.getCode(), typesById).getKey()).root(t.isRootType()).typeNature(t.getTypeNature() != null ? t.getTypeNature().value() : null).order(coll.getOrder().intValue()).parentTypeCode(t.getCode()).multiple(coll.isMultiple()).visible(coll.isVisible()).attrs(this.buildAttributes(typeId.getValue().getTypeAttributes())).build();
    }

    private List<AttributeType> buildAttributes(DomainTypeAttributes typeAttributes) {
        if (typeAttributes == null) {
            return Collections.emptyList();
        }
        return typeAttributes.getTypeAttribute().stream().map(a -> AttributeType.builder().attrType(a.getAttributeType().value()).code(a.getCode()).name(a.getName()).groupName(a.getGroupName()).description(a.getDescription()).build()).toList();
    }

    private Map.Entry<Integer, DomainType> findTypeId(String code, Map<Integer, DomainType> typesById) {
        return typesById.entrySet().stream().filter(e -> Objects.equals(((DomainType)e.getValue()).getCode(), code)).findAny().orElseThrow();
    }

    private DomainReaderVisitor<Path> buildDomainFileSystemVisitor(Path profileDirectory, DomainDefinition domainDefinitionXml) {
        FileSystemSnapshotHelper fileHelper = new FileSystemSnapshotHelper();
        return new DomainReaderVisitorImpl(fileHelper.getDirectoryName(profileDirectory), fileHelper, new DomainDefinitionXmlHelper(domainDefinitionXml), new DomainDirectoryAnalyzer(fileHelper));
    }

    private static List<DomainType> getTypes(DomainDefinition definitionXml) {
        if (definitionXml.getDomainTypes() == null) {
            return Collections.emptyList();
        }
        return definitionXml.getDomainTypes().getDomainType();
    }
}

