/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.helper;

import io.higson.runtime.core.datasource.snapshot.IncorrectSnapshotException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public final class SnapshotDirHelper {
    private static final String PROFILES_PREFIX = "@profiles";
    private static final String GLOBAL_PREFIX = "@global";
    private static final String FULL_CODE_DELIMITER = ".";

    private SnapshotDirHelper() {
    }

    public static String getFullCode(Path path, String[] segments, String version) {
        int fullCodeDirIdx;
        List<String> segmentsList = Arrays.asList(segments);
        int n = fullCodeDirIdx = version == null ? segmentsList.lastIndexOf(GLOBAL_PREFIX) + 1 : segmentsList.lastIndexOf(PROFILES_PREFIX) + 5;
        if (segmentsList.size() < fullCodeDirIdx) {
            throw new IncorrectSnapshotException("Incorrect snapshot path " + path);
        }
        String fullCode = String.join((CharSequence)FULL_CODE_DELIMITER, segmentsList.subList(fullCodeDirIdx, segmentsList.size()));
        return FilenameUtils.getBaseName((String)fullCode);
    }

    public static String getProfile(Path path, String[] segments) {
        if (!Arrays.asList(segments).contains(PROFILES_PREFIX)) {
            return null;
        }
        int profileIdx = Arrays.asList(segments).lastIndexOf(PROFILES_PREFIX) + 1;
        if (profileIdx > segments.length) {
            throw new IncorrectSnapshotException("Cannot find profile directory inside @profiles " + path.toString());
        }
        return segments[profileIdx];
    }

    public static String getRegion(Path path, String[] segments) {
        if (!Arrays.asList(segments).contains(PROFILES_PREFIX)) {
            return null;
        }
        int regionIdx = Arrays.asList(segments).lastIndexOf(PROFILES_PREFIX) + 3;
        if (regionIdx > segments.length) {
            throw new IncorrectSnapshotException("Cannot find region directory inside @profiles " + path.toString());
        }
        return segments[regionIdx];
    }

    public static String getVersion(Path path, String[] segments) {
        if (!Arrays.asList(segments).contains(PROFILES_PREFIX)) {
            return null;
        }
        int versionIdx = Arrays.asList(segments).lastIndexOf(PROFILES_PREFIX) + 4;
        if (versionIdx > segments.length) {
            throw new IncorrectSnapshotException("Cannot find version directory inside @profiles " + path.toString());
        }
        return segments[versionIdx];
    }
}

