/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.parameter;

import io.higson.runtime.alias.LevelMapper;
import io.higson.runtime.core.datasource.VersionDao;
import io.higson.runtime.core.datasource.snapshot.helper.SnapshotDataSourceConstants;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterDetails;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterMeta;
import io.higson.runtime.core.datasource.snapshot.parameter.SnapshotParameterReader;
import io.higson.runtime.core.versioninterceptor.VersionInterceptor;
import io.higson.runtime.dao.parameter.ParameterDao;
import io.higson.runtime.decoder.MpDecodingStrategy;
import io.higson.runtime.engine.core.decoder.ValueDecoder;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.model.ParameterLevel;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.sync.Trackable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotParameterDao
implements ParameterDao {
    private static final Logger log = LoggerFactory.getLogger(SnapshotParameterDao.class);
    private final SnapshotParameterReader snapshotParamDirReader;
    private final VersionDao versionDao;
    private MpDecodingStrategy decodingStrategy;

    @Override
    public Parameter getParameter(String code, String ver, int sid) {
        return this.buildParameter(this.getParamDetails(code, ver));
    }

    @Override
    public Parameter getParameter(String code, String ver, int sid, int mid) {
        return this.getParameter(code, ver, sid);
    }

    @Override
    public Collection<ParameterEntry> findEntries(int pid, String[][] inputLevels) {
        return this.filterEntries(inputLevels, this.snapshotParamDirReader.getEntries(pid, this.versionDao.getAllSchedules()));
    }

    @Override
    public Date getMaxLastUpdate() {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    @Override
    public Date getMaxLastUpdate(boolean developerMode) {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    @Override
    public List<Trackable> getAllLastUpdates(boolean developerMode) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getNamesByRegionsInProfiles(Map<String, List<String>> profileToRegions) {
        return Collections.emptyList();
    }

    @Override
    public List<Parameter> getAllHeads() {
        Map<Integer, RegionVersion> allRegionVersions = this.versionDao.getAllRegionVersions();
        return this.snapshotParamDirReader.getParametersMeta().values().stream().map(parameterMeta -> this.createParam((ParameterMeta)parameterMeta, allRegionVersions)).toList();
    }

    @Override
    public Parameter getHeader(int pid) {
        return null;
    }

    @Override
    public void setInterceptor(VersionInterceptor interceptor) {
    }

    private ParameterDetails getParamDetails(String code, String ver) {
        ParameterDetails parameterDetails = this.snapshotParamDirReader.getParameterDetails(code, ver, this.versionDao.getAllSchedules());
        if (parameterDetails.externalSource() != null) {
            throw new UnsupportedOperationException("Param " + code + " with external source not allowed to test from snapshot tests");
        }
        return parameterDetails;
    }

    private Parameter buildParameter(ParameterDetails parameterDetails) {
        Parameter parameter = new Parameter();
        parameter.setId(parameterDetails.id());
        parameter.setName(parameterDetails.code());
        parameter.setCacheable(parameterDetails.cacheable());
        parameter.setNullable(parameterDetails.nullable());
        parameter.setDictionary(parameterDetails.dictionary());
        parameter.setSortText(parameterDetails.sort());
        parameter.setLastUpdate(SnapshotDataSourceConstants.YEAR_AGO);
        parameter.setSlave(parameterDetails.slave());
        parameter.setMasterName(parameterDetails.masterName());
        parameter.setDistinct(parameterDetails.distinct());
        parameter.setLoadedNow();
        parameterDetails.inputLevels().forEach(il -> {
            ParameterLevel pl = new ParameterLevel();
            pl.setId(il.id());
            pl.setOrderNo(il.orderNr());
            pl.setName(il.name());
            pl.setType(il.type());
            pl.setMatcher(il.matcher());
            pl.setReverseMatcher(il.reverseMatcher());
            pl.setMatchMode(il.matchMode());
            pl.setLevelCreator(il.levelCreator());
            parameter.addLevel(pl);
            parameter.setInputLevels(parameter.getInputLevels() + 1);
        });
        parameterDetails.outputLevels().forEach(ol -> {
            ParameterLevel level = new ParameterLevel();
            level.setId(ol.id());
            level.setOrderNo(ol.orderNo());
            level.setName(ol.name());
            level.setType(ol.type());
            level.setArray(ol.array());
            level.setExternal(ol.external());
            level.setValueDecoder(this.createValueDecoder());
            parameter.addLevel(level);
        });
        parameter.postprocess();
        if (parameter.isSlave()) {
            this.prepareSlave(parameter, parameterDetails.version());
        }
        if (parameter.isCacheable()) {
            this.fetchEntries(parameter);
        }
        return parameter;
    }

    private void prepareSlave(Parameter slave, String version) {
        Parameter master = this.buildParameter(this.snapshotParamDirReader.getParameterDetails(slave.getMasterName(), version, this.versionDao.getAllSchedules()));
        LevelMapper levelMapper = new LevelMapper(master, slave);
        slave.setLevelMapper(levelMapper);
        slave.setMid(master.getId());
    }

    private void fetchEntries(Parameter parameter) {
        this.snapshotParamDirReader.getEntries(parameter.getId(), parameter.getLevelMapper(), this.versionDao.getAllSchedules()).forEach(parameter::addEntry);
    }

    private List<ParameterEntry> filterEntries(String[][] inputLevels, List<ParameterEntry> entries) {
        Stream<Object> stream = entries.stream();
        for (int i = 0; i < inputLevels.length; ++i) {
            String[] nonNullLevelArgs = (String[])Stream.of(inputLevels[i]).filter(Objects::nonNull).toArray(String[]::new);
            int levelIdx = i;
            stream = nonNullLevelArgs.length == 0 ? stream.filter(entry -> entry.getLevels()[levelIdx] == null) : stream.filter(entry -> Objects.equals(entry.getLevels()[levelIdx], this.createLevelArg(nonNullLevelArgs)));
        }
        return stream.toList();
    }

    private Object createLevelArg(String[] levelArgs) {
        return levelArgs.length == 1 ? levelArgs[0] : levelArgs;
    }

    private Parameter createParam(ParameterMeta parameterMeta, Map<Integer, RegionVersion> allRegionVersions) {
        Parameter parameter = new Parameter();
        parameter.setName(parameterMeta.code());
        parameter.setRegionVersionId(this.getVersionId(parameterMeta, allRegionVersions));
        return parameter;
    }

    private int getVersionId(ParameterMeta parameterMeta, Map<Integer, RegionVersion> allRegionVersions) {
        if (parameterMeta.version() != null) {
            Optional<RegionVersion> version = allRegionVersions.values().stream().filter(rv -> Objects.equals(rv.getRegion(), parameterMeta.region()) && Objects.equals(rv.getNumber(), parameterMeta.version()) && Objects.equals(rv.getProfileCode(), parameterMeta.profile())).findAny();
            if (version.isPresent()) {
                return version.get().getId();
            }
            log.warn("Cannot find param ({}.{},{}) version in all snapshot versions", new Object[]{parameterMeta.profile(), parameterMeta.region(), parameterMeta.version()});
        }
        return 0;
    }

    private ValueDecoder createValueDecoder() {
        return this.decodingStrategy != null ? this.decodingStrategy.createCascadeDecoder() : null;
    }

    public SnapshotParameterDao(SnapshotParameterReader snapshotParamDirReader, VersionDao versionDao) {
        this.snapshotParamDirReader = snapshotParamDirReader;
        this.versionDao = versionDao;
    }

    public void setDecodingStrategy(MpDecodingStrategy decodingStrategy) {
        this.decodingStrategy = decodingStrategy;
    }
}

