/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.dao.external;

import io.higson.runtime.dao.BaseDao;
import io.higson.runtime.dao.external.ExternalStorageDao;
import io.higson.runtime.dao.external.ExternalValueSetter;
import io.higson.runtime.dao.external.ResolveRequest;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.helper.MpHelper;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.model.ParameterLevel;
import io.higson.runtime.sql.DialectRegistry;
import io.higson.runtime.sql.DialectTemplate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbExternalStorageDao
extends BaseDao
implements ExternalStorageDao {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MpHelper helper = new MpHelper();
    private final DialectTemplate dialectTemplate = DialectRegistry.getDialectTemplate();

    public DbExternalStorageDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        super(dataSource, connectionInterceptor);
    }

    @Override
    public void resolveExternalValues(Parameter p) {
        this.resolveExternalValues(p, p.getEntries());
    }

    @Override
    public void resolveExternalValues(Parameter p, Collection<ParameterEntry> rows) {
        this.log.trace("enter resolveExternalValues");
        long t = System.currentTimeMillis();
        for (int i = 0; i < p.getLevelCount(); ++i) {
            ParameterLevel parameterLevel = p.getLevel(i);
            if (!parameterLevel.isExternal()) continue;
            this.resolveExternalLevel(rows, i);
        }
        this.log.trace("leave resolveExternalValues, time={}", (Object)(System.currentTimeMillis() - t));
    }

    @Override
    public void resolveExternalLevel(Collection<? extends ParameterEntry> rows, int levelIndex) {
        this.log.trace("resolving external values for {} rows on level: {}", (Object)rows.size(), (Object)levelIndex);
        HashMap<Integer, ResolveRequest> buffer = new HashMap<Integer, ResolveRequest>();
        for (ParameterEntry parameterEntry : rows) {
            String[] row = parameterEntry.getLevels();
            String addr = row[levelIndex];
            if (addr == null || !addr.startsWith("@")) continue;
            int externalId = Integer.parseInt(addr.substring(1));
            buffer.put(externalId, new ResolveRequest(parameterEntry, levelIndex, externalId));
            if (buffer.size() != 1000) continue;
            this.fetchExternalValues(buffer);
        }
        this.fetchExternalValues(buffer);
    }

    @Override
    public void fetchExternalValues(Map<Integer, ResolveRequest> buffer) {
        if (buffer.isEmpty()) {
            return;
        }
        int n = buffer.size();
        int i = 0;
        Object[] ids = new Integer[n];
        for (ResolveRequest request : buffer.values()) {
            ids[i++] = request.externalId;
        }
        String sb = " select id, value from @externalstorage where id in (" + this.helper.createInListPattern(n) + ")";
        String sql = this.dialectTemplate.parse(sb);
        this.log.trace("using sql: {}", (Object)sql);
        this.jdbcTemplate().query(sql, ids, new ExternalValueSetter(buffer));
        buffer.clear();
    }
}

