/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.prepared;

import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.engine.core.prepared.PreparedEntry;
import java.util.Arrays;

public class PreparedOutput {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final String[] levels;

    public PreparedOutput(ParameterEntry entry, int inputLevelCount) {
        this.levels = this.prepare(entry.getLevels(), inputLevelCount);
    }

    public PreparedOutput(PreparedEntry entry, int inputLevelCount) {
        this.levels = this.prepare(entry.getLevels(), inputLevelCount);
    }

    public String getLevel(int k) {
        return k < this.levels.length ? this.levels[k] : null;
    }

    public String[] getLevels() {
        return this.levels;
    }

    private String[] prepare(String[] levels, int inputLevelCount) {
        return this.normalizeLevels(this.skipInput(levels, inputLevelCount));
    }

    private String[] skipInput(String[] levels, int inputLevelCount) {
        return Arrays.copyOfRange(levels, inputLevelCount, levels.length);
    }

    private String[] normalizeLevels(String[] levels) {
        String[] normalized = this.trimRight(levels);
        this.internalizeLevelValues(normalized);
        return normalized;
    }

    private String[] trimRight(String[] array) {
        int len;
        if (array == null) {
            return EMPTY_ARRAY;
        }
        for (len = array.length; len > 0 && array[len - 1] == null; --len) {
        }
        return len < array.length ? Arrays.copyOf(array, len) : array;
    }

    private void internalizeLevelValues(String[] levels) {
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i] == null) continue;
            levels[i] = levels[i].intern();
        }
    }
}

