/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.number;

import io.higson.runtime.engine.annotated.annotations.ParamType;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.util.EngineUtil;
import io.higson.runtime.helper.parser.CachingNumberParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;

@ParamType(value="number")
public class NumberType
implements Type<NumberHolder> {
    @Override
    public String encode(NumberHolder value) {
        return value.getString();
    }

    @Override
    public NumberHolder decode(String text) {
        BigDecimal value = EngineUtil.hasText(text) ? this.parse(text) : null;
        return new NumberHolder(value);
    }

    @Override
    public NumberHolder convert(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return this.decode(str);
        }
        if (obj instanceof Number) {
            BigDecimal result;
            Number n = (Number)obj;
            if (n instanceof Double || n instanceof Float) {
                result = BigDecimal.valueOf(n.doubleValue()).stripTrailingZeros();
                if (result.scale() < 0) {
                    result = result.setScale(0, RoundingMode.UNNECESSARY);
                }
            } else {
                result = n instanceof BigDecimal ? (BigDecimal)n : (n instanceof BigInteger ? new BigDecimal((BigInteger)n) : new BigDecimal(n.longValue()));
            }
            return new NumberHolder(result);
        }
        if (obj == null) {
            return new NumberHolder(null);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    public NumberHolder[] newArray(int size) {
        return new NumberHolder[size];
    }

    private BigDecimal parse(String str) {
        return CachingNumberParser.parse(str);
    }

    public boolean canDecode(String text) {
        return text != null && !text.isBlank() && NumberUtils.isCreatable((String)text.trim().replace(",", "."));
    }
}

