/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow;

import io.higson.runtime.flow.ActionArgument;
import io.higson.runtime.flow.ActionType;
import java.util.Collections;
import java.util.List;

public class Action {
    private ActionType type;
    private String value;
    private String outputVariable;
    private List<ActionArgument> arguments;

    public List<ActionArgument> getArguments() {
        return this.arguments != null ? this.arguments : Collections.emptyList();
    }

    Action(ActionType type, String value, String outputVariable, List<ActionArgument> arguments) {
        this.type = type;
        this.value = value;
        this.outputVariable = outputVariable;
        this.arguments = arguments;
    }

    public static ActionBuilder builder() {
        return new ActionBuilder();
    }

    public ActionType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getOutputVariable() {
        return this.outputVariable;
    }

    public String toString() {
        return "Action(type=" + this.getType() + ", value=" + this.getValue() + ", outputVariable=" + this.getOutputVariable() + ", arguments=" + this.getArguments() + ")";
    }

    public static class ActionBuilder {
        private ActionType type;
        private String value;
        private String outputVariable;
        private List<ActionArgument> arguments;

        ActionBuilder() {
        }

        public ActionBuilder type(ActionType type) {
            this.type = type;
            return this;
        }

        public ActionBuilder value(String value) {
            this.value = value;
            return this;
        }

        public ActionBuilder outputVariable(String outputVariable) {
            this.outputVariable = outputVariable;
            return this;
        }

        public ActionBuilder arguments(List<ActionArgument> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Action build() {
            return new Action(this.type, this.value, this.outputVariable, this.arguments);
        }

        public String toString() {
            return "Action.ActionBuilder(type=" + this.type + ", value=" + this.value + ", outputVariable=" + this.outputVariable + ", arguments=" + this.arguments + ")";
        }
    }
}

