/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow.dto;

import io.higson.runtime.flow.Action;
import io.higson.runtime.flow.ActionArgument;
import io.higson.runtime.flow.Flow;
import io.higson.runtime.flow.Link;
import io.higson.runtime.flow.Node;
import io.higson.runtime.flow.Variable;
import io.higson.runtime.flow.dto.ActionArgumentDto;
import io.higson.runtime.flow.dto.ActionDto;
import io.higson.runtime.flow.dto.FlowDto;
import io.higson.runtime.flow.dto.FlowDtoConverter;
import io.higson.runtime.flow.dto.LinkDto;
import io.higson.runtime.flow.dto.NodeDto;
import io.higson.runtime.flow.dto.VariableDto;
import java.util.List;

public final class FlowRuntimeConverter {
    public static Flow convert(String flowString) {
        FlowDto flowDto = FlowDtoConverter.convertToDto(flowString);
        return FlowRuntimeConverter.convert(flowDto);
    }

    public static Flow convert(FlowDto flowDto) {
        return Flow.builder().arguments(flowDto.getArguments()).variables(FlowRuntimeConverter.mapVariables(flowDto.getVariables())).nodes(FlowRuntimeConverter.mapNodes(flowDto.getNodes())).startNodeId(flowDto.getStartNodeId()).build();
    }

    private static List<Node> mapNodes(List<NodeDto> nodes) {
        return nodes.stream().map(n -> Node.builder().id(n.getId()).defaultNextNode(n.getDefaultNextNode()).links(FlowRuntimeConverter.mapLinks(n.getLinks())).actions(FlowRuntimeConverter.mapActions(n.getActions())).build()).toList();
    }

    private static List<Action> mapActions(List<ActionDto> actions) {
        return actions.stream().map(a -> Action.builder().value(a.getValue()).outputVariable(a.getOutputVariable()).type(a.getType()).arguments(FlowRuntimeConverter.mapArguments(a.getArguments())).build()).toList();
    }

    private static List<ActionArgument> mapArguments(List<ActionArgumentDto> arguments) {
        return arguments.stream().map(a -> ActionArgument.builder().value(a.getValue()).sourceType(a.getSource()).build()).toList();
    }

    private static List<Link> mapLinks(List<LinkDto> links) {
        return links.stream().map(l -> Link.builder().condition(l.condition).target(l.target).build()).toList();
    }

    private static List<Variable> mapVariables(List<VariableDto> variables) {
        return variables.stream().map(v -> Variable.builder().name(v.getName()).type(v.getType()).value(v.getValue()).returned(v.isReturned()).build()).toList();
    }

    private FlowRuntimeConverter() {
    }
}

