/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.function.log;

import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.engine.core.ParameterValueNotFoundException;
import io.higson.runtime.engine.core.UnknownParameterException;
import io.higson.runtime.engine.core.output.GettingWrongTypeException;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.function.log.FunctionLogLevel;
import io.higson.runtime.function.log.FunctionLogLevelCache;
import io.higson.runtime.model.Function;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionLogLevelResolver {
    private static final Logger log = LoggerFactory.getLogger(FunctionLogLevelResolver.class);
    private static final String SYSTEM_FUNCTION_LOG_LEVEL_PARAMETER_NAME = "system.function.logging.level";
    private static final String SYSTEM_FUNCTION_LOG_LEVEL_PARAMETER_CTX_CODE = "code";
    private final HigsonEngine higsonEngine;
    private final FunctionLogLevelCache cache;

    public FunctionLogLevelResolver(HigsonEngine higsonEngine, FunctionLogLevelCache cache) {
        this.higsonEngine = higsonEngine;
        this.cache = cache;
    }

    public FunctionLogLevelResolver(HigsonEngine higsonEngine) {
        this(higsonEngine, new FunctionLogLevelCache());
    }

    public FunctionLogLevel getFunctionFinalLogLevel(Function function) {
        String code = function.getCode();
        FunctionLogLevel logLevel = this.cache.get(code);
        if (logLevel == null) {
            logLevel = this.getFunctionSystemLogLevel(code).orElse(function.getLogLevel());
            this.cache.put(code, logLevel);
        }
        return logLevel;
    }

    public Optional<FunctionLogLevel> getFunctionSystemLogLevel(String functionCode) {
        HigsonContext ctx = new HigsonContext(new Object[0]).set(SYSTEM_FUNCTION_LOG_LEVEL_PARAMETER_CTX_CODE, functionCode);
        try {
            ParamValue paramValue = this.higsonEngine.get(SYSTEM_FUNCTION_LOG_LEVEL_PARAMETER_NAME, ctx);
            if (paramValue == null) {
                return Optional.empty();
            }
            return Optional.of(FunctionLogLevel.valueOf(this.getRawFunctionLogLevel(paramValue)));
        }
        catch (GettingWrongTypeException | IllegalArgumentException exc) {
            log.error("Parameter system.function.logging.level contains value that is not an acceptable logging level.");
        }
        catch (ParameterValueNotFoundException | UnknownParameterException | HigsonRuntimeException runtimeException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private String getRawFunctionLogLevel(ParamValue paramValue) {
        return paramValue.getString() != null ? paramValue.getString().toUpperCase() : "";
    }

    public String toString() {
        return "FunctionLogLevelResolver[cache=" + this.cache + "]";
    }
}

