/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.snapshot;

import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.processor.BeanListProcessor;
import com.univocity.parsers.common.processor.BeanWriterProcessor;
import com.univocity.parsers.common.processor.RowWriterProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public class CsvUtils {
    private static final char CSV_DELIMITER = ';';

    public static CsvWriter getSkipQuoteCsvWriter(Writer writer) {
        return new CsvWriter(writer, CsvUtils.skipQuoteSettings());
    }

    public static CsvWriter getCsvWriter(Writer writer, Class<?> beanType) {
        return new CsvWriter(writer, CsvUtils.writerSettings(beanType));
    }

    private static CsvWriterSettings writerSettings(Class<?> beanType) {
        CsvWriterSettings settings = CsvUtils.commonWriterSettings();
        settings.setRowWriterProcessor((RowWriterProcessor)new BeanWriterProcessor(beanType));
        return settings;
    }

    private static CsvWriterSettings skipQuoteSettings() {
        CsvWriterSettings settings = CsvUtils.commonWriterSettings();
        ((CsvFormat)settings.getFormat()).setQuote('\u0000');
        ((CsvFormat)settings.getFormat()).setQuoteEscape('\u0000');
        settings.setQuoteEscapingEnabled(false);
        return settings;
    }

    private static CsvWriterSettings commonWriterSettings() {
        CsvWriterSettings settings = new CsvWriterSettings();
        ((CsvFormat)settings.getFormat()).setDelimiter(';');
        return settings;
    }

    public static <T extends Context> CsvParser getCsvParser(Processor<T> processor) {
        return new CsvParser(CsvUtils.parserSettings(processor));
    }

    public <T> List<T> parse(Path file, Class<T> clazz) throws IOException {
        BeanListProcessor rowProcessor = new BeanListProcessor(clazz);
        CsvParser parser = new CsvParser(CsvUtils.parserSettings(rowProcessor));
        try (BufferedReader reader = Files.newBufferedReader(file);){
            parser.parse((Reader)reader);
        }
        return rowProcessor.getBeans();
    }

    private static <T extends Context> CsvParserSettings parserSettings(Processor<T> processor) {
        CsvParserSettings settings = new CsvParserSettings();
        ((CsvFormat)settings.getFormat()).setDelimiter(';');
        settings.setLineSeparatorDetectionEnabled(true);
        settings.setHeaderExtractionEnabled(true);
        settings.setProcessor(processor);
        return settings;
    }
}

