/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.snapshot;

import io.higson.runtime.helper.snapshot.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import pl.decerto.mpp.imports.xml.domain.DomainDefinition;

public class DomainXMLUtils {
    private static final String CONFIG_XSD = "schema/mpp-domain.xsd";

    private DomainXMLUtils() {
        throw new UnsupportedOperationException();
    }

    public static DomainDefinition getDomain(String xmlFilePath) {
        return DomainXMLUtils.getDomain(Paths.get(xmlFilePath, new String[0]));
    }

    public static DomainDefinition getDomain(Path xmlFilePath) {
        return XMLUtils.validateAndUnmarshalXML(xmlFilePath.toString(), CONFIG_XSD, DomainDefinition.class);
    }

    public static DomainDefinition getDomain(InputStream inputStream) {
        return XMLUtils.validateAndUnmarshalXML(inputStream, CONFIG_XSD, DomainDefinition.class);
    }

    public static DomainDefinition getDomainFromZip(Path pathToDefinitionInZip) throws IOException {
        try (InputStream defInputStream = Files.newInputStream(pathToDefinitionInZip, new OpenOption[0]);){
            XMLUtils.validateXML(defInputStream, CONFIG_XSD);
        }
        defInputStream = Files.newInputStream(pathToDefinitionInZip, new OpenOption[0]);
        try {
            DomainDefinition domainDefinition = XMLUtils.unmarshal(defInputStream, DomainDefinition.class);
            return domainDefinition;
        }
        finally {
            if (defInputStream != null) {
                defInputStream.close();
            }
        }
    }
}

