/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.snapshot;

import io.higson.runtime.helper.snapshot.SnapshotFileHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;

public class FileSystemSnapshotHelper
implements SnapshotFileHelper {
    @Override
    public boolean isFile(Path path, String fileExtension) {
        return Files.isRegularFile(path, new LinkOption[0]) && StringUtils.endsWith((CharSequence)this.getFileName(path), (CharSequence)fileExtension);
    }

    @Override
    public boolean isFile(Path path, String prefix, String fileExtension) {
        return Files.isRegularFile(path, new LinkOption[0]) && StringUtils.startsWith((CharSequence)this.getFileName(path), (CharSequence)prefix) && StringUtils.endsWith((CharSequence)this.getFileName(path), (CharSequence)fileExtension);
    }

    @Override
    public boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    public boolean isDirectory(Path path, String name) {
        return Files.isDirectory(path, new LinkOption[0]) && path.endsWith(name);
    }

    @Override
    public String getDirectoryName(Path path) {
        return StringUtils.substringBefore((String)this.getFileName(path), (String)"/");
    }

    @Override
    public String getFileName(Path path, String fileExtension) {
        return StringUtils.substringBefore((String)this.getFileName(path), (String)fileExtension);
    }

    @Override
    public String getParent(Path path) {
        return StringUtils.join((Object[])new String[]{path.getParent().toString(), "/"});
    }

    @Override
    public byte[] readAllBytes(Path path) throws IOException {
        return Files.readAllBytes(path);
    }

    @Override
    public BufferedReader newBufferedReader(Path path) throws IOException {
        return Files.newBufferedReader(path, StandardCharsets.UTF_8);
    }

    @Override
    public boolean containsLineWithElement(Path path, String element) throws IOException {
        return Files.readAllLines(path).stream().anyMatch(o -> o.startsWith(element));
    }

    private String getFileName(Path path) {
        return path.getFileName().toString();
    }
}

