/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.snapshot;

import io.higson.runtime.core.datasource.snapshot.Messages;
import io.higson.runtime.exception.ImportException;
import io.higson.runtime.helper.snapshot.XMLValidator;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static final Logger log = LoggerFactory.getLogger(XMLUtils.class);
    private static final String XML_VALIDATION_ERROR = "common.import.xmlValidationError";
    private static final String XML_FILE_ERROR = "common.import.xmlFileError";
    private static final String INCORRECT_XML = "common.import.incorrectXML";

    private XMLUtils() {
        throw new IllegalStateException("Can't be invoked. This is util class.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T validateAndUnmarshalXML(String xmlFilename, String xsd, Class<T> clazz) {
        try (FileInputStream stream = new FileInputStream(xmlFilename);){
            XMLValidator.validate(stream, xsd);
            T t = XMLUtils.unmarshal(xmlFilename, clazz);
            return t;
        }
        catch (SAXException e) {
            throw new ImportException(Messages.message(XML_VALIDATION_ERROR), e);
        }
        catch (IOException e) {
            throw new ImportException(Messages.message(XML_FILE_ERROR), e);
        }
    }

    public static void validateXML(InputStream stream, String xsd) {
        try {
            XMLValidator.validate(stream, xsd);
        }
        catch (SAXException e) {
            throw new ImportException(Messages.message(XML_VALIDATION_ERROR), e);
        }
        catch (IOException e) {
            throw new ImportException(Messages.message(XML_FILE_ERROR), e);
        }
    }

    public static <T> T validateAndUnmarshalXML(InputStream stream, String xsd, Class<T> clazz) {
        try {
            String source = new String(stream.readAllBytes(), Charset.defaultCharset());
            XMLValidator.validate(source, xsd);
            return (T)JAXB.unmarshal((Reader)new StringReader(source), clazz);
        }
        catch (SAXException e) {
            throw new ImportException(Messages.message(XML_VALIDATION_ERROR), e);
        }
        catch (IOException e) {
            throw new ImportException(Messages.message(XML_FILE_ERROR), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String xmlFilename, Class<T> clazz) {
        try (FileInputStream stream = new FileInputStream(xmlFilename);){
            T t = XMLUtils.unmarshal(clazz, stream);
            return t;
        }
        catch (JAXBException | FileNotFoundException e) {
            throw new ImportException(Messages.message(INCORRECT_XML), e);
        }
        catch (IOException e) {
            throw new ImportException(Messages.message(XML_FILE_ERROR), e);
        }
        catch (ParserConfigurationException e) {
            throw new ImportException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ImportException(Messages.message(XML_VALIDATION_ERROR), e);
        }
    }

    public static <T> T unmarshal(InputStream stream, Class<T> clazz) {
        try {
            return XMLUtils.unmarshal(clazz, stream);
        }
        catch (JAXBException e) {
            throw new ImportException(Messages.message(INCORRECT_XML), e);
        }
        catch (ParserConfigurationException e) {
            throw new ImportException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ImportException(Messages.message(XML_VALIDATION_ERROR), e);
        }
    }

    private static <T> T unmarshal(Class<T> clazz, InputStream stream) throws ParserConfigurationException, SAXException, JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
        return (T)jc.createUnmarshaller().unmarshal(XMLUtils.getXmlSource(stream), clazz).getValue();
    }

    private static Source getXmlSource(InputStream stream) throws ParserConfigurationException, SAXException {
        return new SAXSource(XMLUtils.createParserFactory().newSAXParser().getXMLReader(), new InputSource(stream));
    }

    private static SAXParserFactory createParserFactory() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return spf;
    }
}

