/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler;

import io.higson.runtime.profiler.AbstractProfilerStat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public class ProfilerBucket<T, S extends AbstractProfilerStat<T>> {
    private final Map<T, S> map = new HashMap<T, S>();
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTime(T key, long time, Function<T, S> keyStatSupplier) {
        try {
            this.lock();
            AbstractProfilerStat stat = (AbstractProfilerStat)this.map.get(key);
            if (stat == null) {
                stat = (AbstractProfilerStat)keyStatSupplier.apply(key);
                this.map.put(key, stat);
            }
            stat.addTime(time);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getStat(T key, Function<S, S> copier) {
        try {
            this.lock();
            AbstractProfilerStat stat = (AbstractProfilerStat)this.map.get(key);
            AbstractProfilerStat abstractProfilerStat = stat != null ? (AbstractProfilerStat)copier.apply(stat) : null;
            return (S)abstractProfilerStat;
        }
        finally {
            this.unlock();
        }
    }

    public List<S> getStats(Function<S, S> copier) {
        try {
            this.lock();
            List<AbstractProfilerStat> list = this.map.keySet().stream().map(key -> this.getStat(key, copier)).toList();
            return list;
        }
        finally {
            this.unlock();
        }
    }

    public void clear() {
        try {
            this.lock();
            this.map.clear();
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }
}

