/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.provider;

import io.higson.runtime.core.datasource.FunctionDao;
import io.higson.runtime.engine.core.function.FunctionRepository;
import io.higson.runtime.helper.uid.Uid;
import io.higson.runtime.helper.uid.UidParser;
import io.higson.runtime.model.Function;
import io.higson.runtime.profiler.engine.EngineProfiler;
import io.higson.runtime.sync.Trackable;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpFunctionProvider
implements FunctionRepository {
    private static final Logger log = LoggerFactory.getLogger(MpFunctionProvider.class);
    private final FunctionDao dao;
    private static final EngineProfiler profiler = EngineProfiler.FUNCTION;

    public MpFunctionProvider(FunctionDao dao) {
        this.dao = dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function loadFunction(String uid) {
        long t = System.currentTimeMillis();
        try {
            Function function = this.load(uid);
            return function;
        }
        finally {
            profiler.addLoadMeasure(uid, t, System.currentTimeMillis());
        }
    }

    private Function load(String uid) {
        log.debug("loading function, uid={}", (Object)uid);
        Uid spec = UidParser.parseUid(uid);
        return this.dao.getFunction(spec.getCode(), spec.getVersion(), spec.getSid());
    }

    public Date getLastUpdate() {
        return this.dao.getMaxLastUpdate();
    }

    public List<Trackable> getAllLastUpdates() {
        return this.dao.getAllLastUpdates();
    }
}

