/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.rhino;

import io.higson.runtime.engine.annotated.annotations.FetchSuggestion;
import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.number.NumberType;
import io.higson.runtime.helper.StrUtil;
import io.higson.runtime.helper.TypeConverter;
import io.higson.runtime.rhino.value.RhinoParamValue;
import io.higson.runtime.utils.DistanceCalculator;
import io.higson.runtime.utils.Location;
import io.higson.runtime.utils.hash.DigestAlgorithm;
import io.higson.runtime.utils.hash.HashUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoUtil {
    private static final Logger log = LoggerFactory.getLogger(RhinoUtil.class);
    public static final RhinoUtil INSTANCE = new RhinoUtil();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final TypeConverter TYPE = TypeConverter.getInstance();

    private RhinoUtil() {
    }

    @FetchSuggestion(value="suggester.hyperon.calculateHaversineDistance")
    public static double calculateHaversineDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        return DistanceCalculator.calculateHaversineDistance(new Location(latitude1, longitude1), new Location(latitude2, longitude2));
    }

    @FetchSuggestion(value="suggester.hyperon.calculateHaversineDistanceSkipHeightDiff")
    public static double calculateHaversineDistance(double latitude1, double longitude1, double elevation1, double latitude2, double longitude2, double elevation2) {
        return DistanceCalculator.calculateHaversineDistance(new Location(latitude1, longitude1, elevation1), new Location(latitude2, longitude2, elevation2));
    }

    public static boolean eq(Object o1, Object o2) {
        try {
            return RhinoUtil.compare(o1, o2) == 0;
        }
        catch (NumberFormatException e) {
            log.warn("eq error", (Throwable)e);
            return false;
        }
    }

    public static boolean gt(Object o1, Object o2) {
        try {
            return RhinoUtil.compare(o1, o2) > 0;
        }
        catch (NumberFormatException e) {
            log.warn("gt error", (Throwable)e);
            return false;
        }
    }

    public static boolean ge(Object o1, Object o2) {
        try {
            return RhinoUtil.compare(o1, o2) >= 0;
        }
        catch (NumberFormatException e) {
            log.warn("ge error", (Throwable)e);
            return false;
        }
    }

    public static boolean lt(Object o1, Object o2) {
        try {
            return RhinoUtil.compare(o1, o2) < 0;
        }
        catch (NumberFormatException e) {
            log.warn("lt error", (Throwable)e);
            return false;
        }
    }

    public static boolean le(Object o1, Object o2) {
        try {
            return RhinoUtil.compare(o1, o2) <= 0;
        }
        catch (NumberFormatException e) {
            log.warn("le error", (Throwable)e);
            return false;
        }
    }

    private static int compare(Object o1, Object o2) {
        if (o1 != null && o2 != null) {
            return RhinoUtil.compareNotNull(o1, o2);
        }
        if (o1 != null) {
            return 1;
        }
        if (o2 != null) {
            return -1;
        }
        return 0;
    }

    private static int compareNotNull(Object o1, Object o2) {
        if (o1 instanceof Number || o2 instanceof Number) {
            return RhinoUtil.compareNumber(o1, o2);
        }
        if (o1 instanceof String && o2 instanceof String) {
            return RhinoUtil.compare((String)o1, (String)o2);
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            return RhinoUtil.compare((Date)o1, (Date)o2);
        }
        if (o1 instanceof Boolean || o2 instanceof Boolean) {
            return RhinoUtil.compareBoolean(o1, o2);
        }
        if (o1.getClass() == o2.getClass()) {
            if (o1 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            return 0;
        }
        return o1.toString().compareTo(o2.toString());
    }

    private static int compareBoolean(Object o1, Object o2) {
        boolean b2;
        boolean b1;
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            b1 = (Boolean)o1;
            b2 = (Boolean)o2;
        } else if (o1 instanceof Boolean) {
            b1 = (Boolean)o1;
            b2 = Boolean.valueOf(o2.toString());
        } else {
            b1 = Boolean.valueOf(o1.toString());
            b2 = (Boolean)o2;
        }
        return RhinoUtil.compareBool(b1, b2);
    }

    private static int compareBool(boolean b1, boolean b2) {
        return (b1 ? 1 : 0) - (b2 ? 1 : 0);
    }

    private static int compareNumber(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            return RhinoUtil.compare((Number)o1, (Number)o2);
        }
        if (o1 instanceof Number) {
            return -RhinoUtil.compare(o2, (Number)o1);
        }
        return RhinoUtil.compare(o1, (Number)o2);
    }

    private static int compare(Number n1, Number n2) {
        double v = n1.doubleValue() - n2.doubleValue();
        return v > 0.0 ? 1 : (v < 0.0 ? -1 : 0);
    }

    private static int compare(Date d1, Date d2) {
        long t2;
        long t1 = d1.getTime();
        return t1 < (t2 = d2.getTime()) ? -1 : (t1 == t2 ? 0 : 1);
    }

    private static int compare(Object o, Number n) {
        double d2;
        double d1 = Double.parseDouble(o.toString().replace(',', '.'));
        double v = d1 - (d2 = n.doubleValue());
        return v > 0.0 ? 1 : (v < 0.0 ? -1 : 0);
    }

    private static int compare(String s1, String s2) {
        try {
            double d1 = Double.parseDouble(s1.replace(',', '.'));
            double d2 = Double.parseDouble(s2.replace(',', '.'));
            double v = d1 - d2;
            return v > 0.0 ? 1 : (v < 0.0 ? -1 : 0);
        }
        catch (NumberFormatException e) {
            return s1.compareTo(s2);
        }
    }

    public static String toLowerCase(Object o) {
        if (o != null) {
            return o.toString().toLowerCase();
        }
        return null;
    }

    public static String toUpperCase(Object o) {
        if (o != null) {
            return o.toString().toUpperCase();
        }
        return null;
    }

    public static int length(Object s) {
        if (s instanceof Collection) {
            return ((Collection)s).size();
        }
        if (s instanceof Object[]) {
            return ((Object[])s).length;
        }
        return s == null ? 0 : s.toString().length();
    }

    public static boolean in(Object o, List<?> list) {
        for (Object obj : list) {
            if (!RhinoUtil.eq(o, obj)) continue;
            return true;
        }
        return false;
    }

    public static Object nvl(Object value, Object ifNull) {
        return value != null ? value : ifNull;
    }

    public static String trim(Object o) {
        if (o != null) {
            return o.toString().trim();
        }
        return null;
    }

    public static List<Object> list() {
        return new ArrayList<Object>();
    }

    public static List<Object> list(Object ... elements) {
        return new ArrayList<Object>(Arrays.asList(elements));
    }

    public static List<Integer> integerList(Integer ... elements) {
        return new ArrayList<Integer>(Arrays.asList(elements));
    }

    public static List<String> stringList(String ... elements) {
        return new ArrayList<String>(Arrays.asList(elements));
    }

    public static List<Object> arrayList(int initialCapacity) {
        return new ArrayList<Object>(initialCapacity);
    }

    public static List<Object> arrayList() {
        return new ArrayList<Object>();
    }

    public static List<Object> arrayList(Object ... elements) {
        return RhinoUtil.list(elements);
    }

    public static Map<Object, Object> map() {
        return new HashMap<Object, Object>();
    }

    private static Map<Object, Object> fill(Map<Object, Object> map, Object[] args) {
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return map;
    }

    public static Map<Object, Object> map(Object ... args) {
        return RhinoUtil.fill(new HashMap<Object, Object>(), args);
    }

    public static Map<Object, Object> hashMap(Object ... args) {
        return RhinoUtil.fill(new HashMap<Object, Object>(), args);
    }

    public static Map<Object, Object> treeMap(Object ... args) {
        return RhinoUtil.fill(new TreeMap<Object, Object>(), args);
    }

    public static Map<Object, Object> linkedHashMap(Object ... args) {
        return RhinoUtil.fill(new LinkedHashMap<Object, Object>(), args);
    }

    public static Set<Object> set() {
        return new HashSet<Object>();
    }

    public static Set<Object> set(Object ... args) {
        return RhinoUtil.hashSet(args);
    }

    public static Set<Object> hashSet(Object ... args) {
        return new HashSet<Object>(Arrays.asList(args));
    }

    public static Set<Object> treeSet(Object ... args) {
        return new TreeSet<Object>(Arrays.asList(args));
    }

    private static int safeSize(int size) {
        return size > 0 ? size : 0;
    }

    public static Object[] objectArray(int size) {
        return new Object[RhinoUtil.safeSize(size)];
    }

    public static Object[] objectArray(Object ... elements) {
        return Arrays.copyOf(elements, elements.length);
    }

    public static Object[] array(Object ... elements) {
        return RhinoUtil.objectArray(elements);
    }

    public static String[] stringArray(int size) {
        return new String[RhinoUtil.safeSize(size)];
    }

    public static String[] stringArray(String ... elements) {
        return Arrays.copyOf(elements, elements.length);
    }

    public static Integer[] integerArray(int size) {
        return new Integer[RhinoUtil.safeSize(size)];
    }

    public static Integer[] integerArray(Integer ... elements) {
        return Arrays.copyOf(elements, elements.length);
    }

    public static Long[] longArray(int size) {
        return new Long[RhinoUtil.safeSize(size)];
    }

    public static Long[] longArray(Long ... elements) {
        return Arrays.copyOf(elements, elements.length);
    }

    public static Object[] array(int size, Class<?> type) {
        return (Object[])Array.newInstance(type, size);
    }

    public static Object[] array(int size, String typeFullName) {
        try {
            Class<?> type = Class.forName(typeFullName);
            return RhinoUtil.array(size, type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("unable to load class: " + typeFullName, e);
        }
    }

    public static Object[][] matrix(int rows, int cols) {
        return new Object[rows][cols];
    }

    public static Class<?> getClazz(String fullName) throws ClassNotFoundException {
        return Class.forName(fullName);
    }

    public static Object[] collectionToArray(Collection<?> col) {
        return col == null ? EMPTY_ARRAY : col.toArray(new Object[col.size()]);
    }

    public static int getInt(Object o) {
        return TYPE.toIntegerHolder(o).intValue();
    }

    public static Integer getInteger(Object o) {
        return TYPE.getInteger(o);
    }

    public static String getString(Object o) {
        return TYPE.getString(o);
    }

    public static BigDecimal getBigDecimal(Object o) {
        return new NumberType().convert(o).getBigDecimal();
    }

    public static <T extends Comparable> List<T> sort(List<T> list) {
        Collections.sort(list);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<T> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static <T> List<T> sortReversed(List<T> list) {
        Collections.sort(list, Collections.reverseOrder());
        return list;
    }

    public static <T> T[] sort(T[] array) {
        Arrays.sort(array);
        return array;
    }

    public static <T> T[] sort(T[] array, Comparator<T> comparator) {
        Arrays.sort(array, comparator);
        return array;
    }

    public static <T> T[] sortReversed(T[] array) {
        Arrays.sort(array, Collections.reverseOrder());
        return array;
    }

    public static <T> List<T> sort(List<T> list, Object obj) {
        if (obj instanceof Comparator) {
            return RhinoUtil.sort(list, (Comparator)obj);
        }
        if (obj instanceof Function) {
            Function f = (Function)obj;
            RhinoUtil.sort(list, new JavaScriptComparator(f));
        }
        return list;
    }

    public static <T> T[] sort(T[] array, Object obj) {
        if (obj instanceof Comparator) {
            return RhinoUtil.sortComparator(array, (Comparator)obj);
        }
        if (obj instanceof Function) {
            Function f = (Function)obj;
            return RhinoUtil.sortComparator(array, new JavaScriptComparator(f));
        }
        return RhinoUtil.sort(array);
    }

    public static String hash(String algo, String separator, String[] elements) {
        return HashUtils.hash(algo, separator, RhinoUtil.toArray(elements));
    }

    public static String hash(String algo, String separator, List<String> elements) {
        return HashUtils.hash(algo, separator, RhinoUtil.toArray(elements));
    }

    public static String hash(String algo, String[] elements) {
        return HashUtils.hash(algo, RhinoUtil.toArray(elements));
    }

    public static String hash(String algo, List<String> elements) {
        return HashUtils.hash(algo, RhinoUtil.toArray(elements));
    }

    public static String sha1(String separator, String[] elements) {
        return HashUtils.sha1(separator, RhinoUtil.toArray(elements));
    }

    public static String sha1(String separator, List<String> elements) {
        return HashUtils.sha1(separator, RhinoUtil.toArray(elements));
    }

    public static String sha1(String[] elements) {
        return HashUtils.sha1(RhinoUtil.toArray(elements));
    }

    public static String sha1(List<String> elements) {
        return HashUtils.sha1(RhinoUtil.toArray(elements));
    }

    public static String sha1(String text) {
        return HashUtils.hashText(DigestAlgorithm.SHA1, text);
    }

    public static String sha256(String separator, String[] elements) {
        return HashUtils.sha256(separator, RhinoUtil.toArray(elements));
    }

    public static String sha256(String separator, List<String> elements) {
        return HashUtils.sha256(separator, RhinoUtil.toArray(elements));
    }

    public static String sha256(String[] elements) {
        return HashUtils.sha256(RhinoUtil.toArray(elements));
    }

    public static String sha256(List<String> elements) {
        return HashUtils.sha256(RhinoUtil.toArray(elements));
    }

    public static String sha256(String text) {
        return HashUtils.hashText(DigestAlgorithm.SHA256, text);
    }

    public static String md5(String separator, String[] elements) {
        return HashUtils.md5(separator, RhinoUtil.toArray(elements));
    }

    public static String md5(String separator, List<String> elements) {
        return HashUtils.md5(separator, RhinoUtil.toArray(elements));
    }

    public static String md5(String[] elements) {
        return HashUtils.md5(RhinoUtil.toArray(elements));
    }

    public static String md5(List<String> elements) {
        return HashUtils.md5(RhinoUtil.toArray(elements));
    }

    public static String md5(String text) {
        return HashUtils.hashText(DigestAlgorithm.MD5, text);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if ("undefined".equals(obj)) {
            return true;
        }
        if (obj instanceof ParamValue) {
            return ((ParamValue)obj).isEmpty();
        }
        if (obj instanceof RhinoParamValue) {
            return ((RhinoParamValue)obj).isEmpty();
        }
        if (obj instanceof MultiValue) {
            return false;
        }
        if (obj instanceof ValueHolder) {
            return ((ValueHolder)obj).isNull();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj).length == 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Iterable) {
            Iterator it = ((Iterable)obj).iterator();
            return !it.hasNext();
        }
        return false;
    }

    public static boolean notEmpty(Object obj) {
        return !RhinoUtil.isEmpty(obj);
    }

    public static boolean isBlank(Object obj) {
        if (obj == null) {
            return true;
        }
        if ("undefined".equals(obj)) {
            return true;
        }
        if (obj instanceof ParamValue) {
            return ((ParamValue)obj).isBlank();
        }
        if (obj instanceof RhinoParamValue) {
            return ((RhinoParamValue)obj).isBlank();
        }
        if (obj instanceof MultiValue) {
            return ((MultiValue)obj).isBlank();
        }
        if (obj instanceof ValueHolder) {
            return ((ValueHolder)obj).isBlank();
        }
        if (obj instanceof Collection) {
            return RhinoUtil.isBlankIterable((Collection)obj);
        }
        if (obj instanceof Object[]) {
            return RhinoUtil.isBlankArray((Object[])obj);
        }
        if (obj instanceof Map) {
            return RhinoUtil.isBlankIterable(((Map)obj).values());
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isBlank((CharSequence)obj);
        }
        if (obj instanceof Iterable) {
            return RhinoUtil.isBlankIterable((Iterable)obj);
        }
        return false;
    }

    public static boolean notBlank(Object obj) {
        return !RhinoUtil.isBlank(obj);
    }

    private static boolean isBlankIterable(Iterable<?> c) {
        if (c == null) {
            return true;
        }
        for (Object obj : c) {
            if (RhinoUtil.isBlank(obj)) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlankArray(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return true;
        }
        for (Object obj : arr) {
            if (RhinoUtil.isBlank(obj)) continue;
            return false;
        }
        return true;
    }

    private static String[] toArray(String[] arr) {
        return arr != null ? arr : new String[]{};
    }

    private static String[] toArray(List<String> list) {
        return list != null ? list.toArray(new String[list.size()]) : new String[]{};
    }

    private static <T> T[] sortComparator(T[] array, Comparator<T> comparator) {
        return RhinoUtil.sort(array, comparator);
    }

    private static int callForInt(Function f, Object ... args) {
        Object r = RhinoUtil.callForObject(f, args);
        return TYPE.toIntegerHolder(r).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object callForObject(Function f, Object ... args) {
        Context cx = Context.enter();
        try {
            Scriptable scope = f.getParentScope();
            Object object = f.call(cx, scope, scope, args);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    private static class JavaScriptComparator<T>
    implements Comparator<T> {
        private final Function f;

        private JavaScriptComparator(Function f) {
            this.f = f;
        }

        @Override
        public int compare(T o1, T o2) {
            return RhinoUtil.callForInt(this.f, o1, o2);
        }
    }
}

