/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sql;

import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.exception.UnrecognizedDialectException;
import io.higson.runtime.sql.DialectTemplate;
import io.higson.runtime.sql.RuntimeDialect;
import io.higson.runtime.sql.dialect.DatabaseDialect;
import io.higson.runtime.sql.dialect.DialectParser;
import io.higson.runtime.sql.dialect.H2RuntimeDialect;
import io.higson.runtime.sql.dialect.HsqlRuntimeDialect;
import io.higson.runtime.sql.dialect.MsSQLRuntimeDialect;
import io.higson.runtime.sql.dialect.MySQLRuntimeDialect;
import io.higson.runtime.sql.dialect.OracleRuntimeDialect;
import io.higson.runtime.sql.dialect.PostgresqlRuntimeDialect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectRegistry {
    private static final Logger log = LoggerFactory.getLogger(DialectRegistry.class);
    public static final RuntimeDialect DEFAULT_DIALECT = new OracleRuntimeDialect();
    private static final Map<String, Object> dialects = new HashMap<String, Object>();
    private static final DialectTemplate template;

    public static void setup(RuntimeDialect dialect) {
        template.setDialect(dialect);
    }

    private static void setupDialectClassName(String className) {
        log.info("using dialect class: {}", (Object)className);
        Class dialectClass = DialectRegistry.classForName(className);
        DialectRegistry.setup((RuntimeDialect)DialectRegistry.createInstance(dialectClass));
    }

    public static void set(Object obj) {
        if (obj instanceof RuntimeDialect) {
            DialectRegistry.setup((RuntimeDialect)obj);
        } else if (obj instanceof String) {
            String code = (String)obj;
            Object value = dialects.get(code);
            if (value != null) {
                log.debug("dialect [{}] mapped to [{}]", (Object)code, value);
                if (value instanceof RuntimeDialect) {
                    DialectRegistry.set(value);
                } else if (value instanceof String) {
                    DialectRegistry.setupDialectClassName(value.toString());
                } else {
                    throw new UnrecognizedDialectException(obj);
                }
                return;
            }
            DialectRegistry.setupDialectClassName(code);
        } else {
            throw new UnrecognizedDialectException(obj);
        }
    }

    @Deprecated
    public void setDialectByUrl(List<Object> objects) {
        String databaseDialect = DialectParser.getDatabaseDialect(objects);
        this.setDialect(databaseDialect);
    }

    public void setDialectByUrl(String jdbcUrl) {
        String databaseDialect = DialectParser.getDatabaseDialect(jdbcUrl);
        this.setDialect(databaseDialect);
    }

    public void setDialect(Object obj) {
        DialectRegistry.set(obj);
    }

    public void setDialectName(String name) {
        boolean supports = DatabaseDialect.supports(name);
        if (!supports) {
            throw new HigsonRuntimeException("Dialect unsupported: " + name);
        }
        RuntimeDialect dialect = DialectRegistry.getDialectFor(name);
        DialectRegistry.set(dialect);
    }

    public static void setSchema(String schema) {
        template.setSchema(schema);
    }

    public void setDialects(Map<String, Object> dialects) {
        DialectRegistry.dialects.putAll(dialects);
    }

    public DialectTemplate create() {
        return template;
    }

    public static RuntimeDialect getDialect() {
        return template.getDialect();
    }

    public static DialectTemplate getDialectTemplate() {
        return template;
    }

    public static RuntimeDialect getDialectFor(String dialectName) {
        if (!dialects.containsKey(dialectName)) {
            throw new UnrecognizedDialectException((Object)dialectName);
        }
        return (RuntimeDialect)dialects.get(dialectName);
    }

    static <T> Class<T> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UnrecognizedDialectException((Object)className, (Throwable)e);
        }
    }

    static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new UnrecognizedDialectException(clazz, (Throwable)e);
        }
    }

    static void logRegisteredDialects() {
        log.debug("registered mpp dialects:");
        for (Map.Entry<String, Object> entry : dialects.entrySet()) {
            String code = entry.getKey();
            Object value = entry.getValue();
            String desc = value instanceof RuntimeDialect ? value.getClass().getName() : String.valueOf(value);
            if (!log.isDebugEnabled()) continue;
            log.debug("  {} : {}", (Object)StringUtils.rightPad((String)code, (int)16), (Object)desc);
        }
    }

    static {
        dialects.put(DatabaseDialect.ORACLE.getDialect(), new OracleRuntimeDialect());
        dialects.put(DatabaseDialect.HSQLAB.getDialect(), new HsqlRuntimeDialect());
        dialects.put(DatabaseDialect.H2.getDialect(), new H2RuntimeDialect());
        dialects.put(DatabaseDialect.MSSQL2012.getDialect(), new MsSQLRuntimeDialect());
        dialects.put(DatabaseDialect.POSTGRESQL.getDialect(), new PostgresqlRuntimeDialect());
        dialects.put(DatabaseDialect.MYSQL.getDialect(), new MySQLRuntimeDialect());
        DialectRegistry.logRegisteredDialects();
        template = new DialectTemplate();
    }
}

