/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sync;

import io.higson.runtime.engine.util.Printer;
import java.util.ArrayList;
import java.util.List;

public class SyncResult<T> {
    private List<T> created = new ArrayList<T>(0);
    private List<T> updated = new ArrayList<T>(0);
    private List<T> deleted = new ArrayList<T>(0);

    public void addCreated(T t) {
        this.created.add(t);
    }

    public void addUpdated(T t) {
        this.updated.add(t);
    }

    public void addDeleted(T t) {
        this.deleted.add(t);
    }

    public List<T> getCreated() {
        return this.created;
    }

    public List<T> getDeleted() {
        return this.deleted;
    }

    public List<T> getUpdated() {
        return this.updated;
    }

    public boolean hasCreates() {
        return !this.created.isEmpty();
    }

    public boolean hasUpdates() {
        return !this.updated.isEmpty();
    }

    public boolean hasDeletes() {
        return !this.deleted.isEmpty();
    }

    public boolean hasAnyChanges() {
        return this.hasCreates() || this.hasUpdates() || this.hasDeletes();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SyncResult[");
        if (!this.created.isEmpty()) {
            sb.append(Printer.print(this.created, "created"));
        }
        if (!this.updated.isEmpty()) {
            sb.append(Printer.print(this.updated, "updated"));
        }
        if (!this.deleted.isEmpty()) {
            sb.append(Printer.print(this.deleted, "deleted"));
        }
        sb.append(']');
        return sb.toString();
    }
}

