/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.utils;

import io.higson.runtime.utils.Location;

public final class DistanceCalculator {
    private static final int EARTH_RADIUS_FACTOR = 6371;

    private DistanceCalculator() {
    }

    public static double calculateHaversineDistance(Location location1, Location location2) {
        double latitudeDistance = Math.toRadians(location2.getLatitude() - location1.getLatitude());
        double longitudeDistance = Math.toRadians(location2.getLongitude() - location1.getLongitude());
        double a = Math.sin(latitudeDistance / 2.0) * Math.sin(latitudeDistance / 2.0) + Math.cos(Math.toRadians(location1.getLatitude())) * Math.cos(Math.toRadians(location2.getLatitude())) * Math.sin(longitudeDistance / 2.0) * Math.sin(longitudeDistance / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double flatDistanceInMeters = 6371.0 * c * 1000.0;
        double height = location2.getElevation() - location1.getElevation();
        return Math.sqrt(Math.pow(flatDistanceInMeters, 2.0) + Math.pow(height, 2.0));
    }
}

