/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.cache;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.cache.MapCache;
import org.smartparam.engine.core.prepared.PreparedParamCache;
import org.smartparam.engine.core.prepared.PreparedParameter;
import pl.decerto.hyperon.runtime.model.Parameter;

public class MapPreparedParamCache
extends MapCache<PreparedParameter>
implements PreparedParamCache {
    private static final Logger log = LoggerFactory.getLogger(MapPreparedParamCache.class);

    @Override
    public void invalidate(int pid) {
        Iterator it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            PreparedParameter pp = (PreparedParameter)entry.getValue();
            Parameter p = (Parameter)pp.getMetadata();
            if (pp.getId() == pid) {
                log.debug("removing pp by pid: {}", (Object)pp);
                it.remove();
                continue;
            }
            if (p == null || !p.isSlave() || p.getMid() != pid) continue;
            log.debug("removing pp by mid: {}", (Object)pp);
            it.remove();
        }
    }
}

