/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.util.reflection;

import eu.infomas.annotation.AnnotationDetector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.smartparam.engine.util.reflection.PackageFilteringReporter;
import org.smartparam.engine.util.reflection.ReflectionsHelper;

public class AnnotatedMethodReporter
extends PackageFilteringReporter
implements AnnotationDetector.MethodReporter {
    private Class<? extends Annotation> reportedClass;
    private Set<Method> annotatedMethods = new HashSet<Method>();
    private Set<String> scannedClasses = new HashSet<String>();

    public AnnotatedMethodReporter(Class<? extends Annotation> reportedClass, String ... packagesToScan) {
        super(reportedClass.getClassLoader(), packagesToScan);
        this.reportedClass = reportedClass;
    }

    public AnnotatedMethodReporter(ClassLoader classLoader, Class<? extends Annotation> reportedClass, String ... packagesToScan) {
        super(classLoader, packagesToScan);
        this.reportedClass = reportedClass;
    }

    public void reportMethodAnnotation(Class<? extends Annotation> annotation, String className, String methodName) {
        if (!this.scannedClasses.contains(className) && this.isWanted(className)) {
            this.scannedClasses.add(className);
            Class<?> classInstance = this.loadClass(className);
            this.annotatedMethods.addAll(ReflectionsHelper.findMethodsAnnotatedWith(annotation, classInstance));
        }
    }

    public Class<? extends Annotation>[] annotations() {
        return new Class[]{this.reportedClass};
    }

    public Set<Method> getAnnotatedMethods() {
        return this.annotatedMethods;
    }
}

